package com.flybits.android.push.services.fcm;

import android.content.Context;

import com.flybits.android.push.PushManager;
import com.flybits.android.push.deserializations.DeserializePushToken;
import com.flybits.android.push.models.PushToken;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;

import static com.flybits.android.push.models.PushToken.API;

public class FlybitsFirebaseInstanceIDService extends FirebaseInstanceIdService {

    private static final String _TAG = "FlybitsFirebaseInstanceIDService";

    @Override
    public void onTokenRefresh() {

        //Getting registration token
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();

        //Displaying token on logcat
        Logger.setTag(_TAG).i("Refreshed token: " + refreshedToken);

        saveFirebaseToken(getBaseContext(), refreshedToken);

        if (SharedElements.getSavedJWTToken(getBaseContext()) != null
                && SharedElements.getSavedJWTToken(getBaseContext()).length() > 0) {
            sendRegistrationToServer(getBaseContext(), refreshedToken);
        }
    }

    private void saveFirebaseToken(Context context, String refreshedToken) {
        PushManager.setFirebaseToken(context, refreshedToken);
    }

    private Result sendRegistrationToServer(Context context, String token) {

        try {
            PushToken resultSerializationObj    = new PushToken(token, null);
            DeserializePushToken deserialization = new DeserializePushToken();
            final String json = deserialization.toJson(resultSerializationObj);
            return FlyAway.post(context, API, json, null, "PushManager.enableFCM", null);
        }catch (FlybitsException e){
            return null;
        }
    }
}
