/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.deserializations;

import android.support.annotation.NonNull;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.deserializations.IDeserializer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializePushNotification
extends IDeserializer<Push> {
    public Push fromJson(JSONObject jObj) {
        try {
            long version = !jObj.isNull("version") ? jObj.getLong("version") : -1L;
            long timestamp = !jObj.isNull("timestamp") ? jObj.getLong("timestamp") : -1L;
            String message = !jObj.isNull("alert") ? jObj.getString("alert") : null;
            String title = !jObj.isNull("title") ? jObj.getString("title") : null;
            String id = !jObj.isNull("id") ? jObj.getString("id") : null;
            String entity = !jObj.isNull("entity") ? jObj.getString("entity") : "unknown";
            String action = !jObj.isNull("action") ? jObj.getString("action") : "unknown";
            String category = !jObj.isNull("category") ? jObj.getString("category") : "unknown";
            String bodyAsString = null;
            if (!jObj.isNull("body")) {
                Object jsonType = jObj.get("body");
                bodyAsString = jsonType instanceof JSONObject ? jObj.getJSONObject("body").toString() : (jsonType instanceof JSONArray ? jObj.getJSONArray("body").toString() : jObj.getString("body"));
            }
            return new Push(id, entity, action, category, version, timestamp, title, message, bodyAsString);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Push fromJson(JSONArray jsonArray) {
        return null;
    }

    public String toJson(@NonNull Push obj) {
        if (obj == null) {
            return "{}";
        }
        JSONObject objJson = new JSONObject();
        try {
            objJson.put("id", (Object)obj.getId());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            objJson.put("version", obj.getVersion());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            objJson.put("category", (Object)obj.getCategory().getKey());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            objJson.put("entity", (Object)obj.getEntity().getKey());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            objJson.put("action", (Object)obj.getAction().getKey());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            objJson.put("alert", (Object)obj.getMessage());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            objJson.put("title", (Object)obj.getTitle());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            objJson.put("body", (Object)obj.getCustomFieldsAsString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return objJson.toString();
    }
}

