package com.flybits.android.push.db.dao;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;

import com.flybits.android.push.models.Push;

import java.util.List;

import static android.arch.persistence.room.OnConflictStrategy.REPLACE;

@Dao
public interface PushDao {

    @Query("SELECT * FROM push")
    List<Push> getAll();

    @Query("SELECT * FROM push")
    LiveData<List<Push>> getLive();

    @Query("SELECT * FROM push WHERE id = :id")
    Push getById(String id);

    @Query("SELECT * FROM push WHERE id = :id")
    LiveData<Push> getByIdLive(String id);

    @Query("SELECT * FROM push WHERE id IN (:ids)")
    List<Push> getByCacheIds(List<String> ids);

    @Query("SELECT * FROM push WHERE id IN (:ids)")
    LiveData<List<Push>> getLiveByCacheIds(List<String> ids);


    @Insert(onConflict = REPLACE)
    void insert(List<Push> pushes);

    @Insert(onConflict = REPLACE)
    void insert(Push push);


    @Query("DELETE FROM push")
    void clear();


    @Update
    void update(Push push);


    @Delete
    void delete(Push push);

    @Query("DELETE FROM push WHERE id IN (:ids)")
    void deleteByIds(List<String> ids);
}
