package com.flybits.android.push.db.caching;

import android.content.Context;
import android.support.annotation.NonNull;

import com.flybits.android.push.db.PushDatabase;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.caching.FlybitsCacheLoader;

import java.util.List;

/**
 * The {@code PushCacheLoader} is responsible for loading cached data associated to a {@link Push}.
 * This data is inserted into the local SQLite DB whenever {@link Push} data is received from the
 * Flybits server.
 */
public class PushCacheLoader extends FlybitsCacheLoader<Push> {

    public static final String PUSH_CACHE_KEY   = "com.flybits.caching.push.NOTIFICATIONS";
    public PushCacheLoader(Context context){
        super(context);
    }

    @Override
    public List<Push> load(List<String> cachedIds) {
        return PushDatabase.getDatabase(getContext()).pushDao().getByCacheIds(cachedIds);
    }

    public void get(final CacheLoader<Push> callback){
        super.get(PUSH_CACHE_KEY, callback);
    }
}
