package com.flybits.android.push.db;

import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.content.Context;

import com.flybits.android.push.db.converters.CustomFieldsConverter;
import com.flybits.android.push.db.converters.PushEnumConverter;
import com.flybits.android.push.db.dao.PushDao;
import com.flybits.android.push.models.Push;

@Database(entities = {Push.class}, version = 2)
@TypeConverters({PushEnumConverter.class, CustomFieldsConverter.class})
public abstract class PushDatabase extends RoomDatabase {

    private static PushDatabase INSTANCE;
    public abstract PushDao pushDao();

    public static PushDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = Room.databaseBuilder(context, PushDatabase.class, "flybits-push-db").build();
        }
        return INSTANCE;
    }

    public static void destroy() {
        INSTANCE = null;
    }

}