package com.flybits.android.push.db.caching;

import android.content.Context;

import com.flybits.android.push.db.PushDatabase;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.caching.FlybitsCacheLoader;

import java.util.List;

/**
 * The {@code PushCacheLoader} is responsible for loading cached data associated to a {@link Push}.
 * This data is inserted into the local SQLite DB whenever {@link Push} data is received from the
 * Flybits server.
 */
public class PushCacheLoader extends FlybitsCacheLoader<Push> {

    private Context context;

    public PushCacheLoader(Context context){
        this.context    = context;
    }

    @Override
    public List<Push> load() {
        return PushDatabase.getDatabase(context).pushDao().getAll();
    }
}
