package com.flybits.android.push.models;

/**
 * Indicates through which type of service the {@code PushToken} was obtained through. Currently,
 * there are only two supported methods; GCM and APNS. For all Android purposes, the only option
 * that should be used is GCM.
 */
public enum PushType {

    /**
     * Indicates that the {@code PushToken} was obtained through Google's GCM service.
     */
    GCM(1),

    /**
     * Indicates an unknown {@code PushType}.
     */
    UNKNOWN (-99);

    private final int key;

    /**
     * Constructor that defines the key for each {@code Type} option.
     *
     * @param key the Integer value representing each {@code Type} option.
     */
    PushType(int key) {
        this.key = key;
    }

    /**
     * Get the Integer representation for the {@code Type} option.
     *
     * @return Integer representation of the {@code Type} option.
     */
    public int getKey() {
        return this.key;
    }

    /**
     * Get the {@code Type} enum value corresponding to an Integer representation.
     *
     * @param key the Integer representation of the {@code Type} enum.
     *
     * @return The {@code Type} enum for the Integer representation.
     */
    public static PushType fromKey(int key) {
        for(PushType type : PushType.values()) {
            if(type.getKey() == key) {
                return type;
            }
        }
        return UNKNOWN;
    }
}
