package com.flybits.android.push.db.caching;

import android.content.Context;

import com.flybits.android.push.db.PushDatabase;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.caching.FlybitsUIListObserver;

/**
 * The {@code PushCacheObserver} class is responsible for creating an {@code Observer} for
 * {@link Push} retrieved from the Flybits server and stored on the local SQLite DB using ROOM.
 * This {@code Observer} listens for {@link Push} changes and notifies the UI whenever a change
 * is detected. It will also trigger the retrieval of the initial {@link Push} object from the DB
 * in order to initialize the view.
 */
public class PushCacheObserver extends FlybitsUIListObserver<Push> {

    private static PushCacheObserver INSTANCE = null;

    private PushCacheObserver(final Context context){
        new Thread(new Runnable() {
            public void run() {
                    setItems(PushDatabase.getDatabase(context).pushDao().getLive());
                }
        }).start();
    }

    /**
     * As the {@code PushCacheObserver} class acts as a {@code Singleton}, it is important to
     * initialize the {@code Singleton} with the proper attributes needed to function correctly.
     *
     * @param context The context of the application.
     * @return The instance of the {@code PushCacheObserver} class which has either been
     * previously initialized or was initialized for the first time now.
     */
    public static PushCacheObserver observe(Context context) {
        if (INSTANCE == null) {
            synchronized (PushCacheObserver.class){
                if (INSTANCE == null){
                    INSTANCE = new PushCacheObserver(context);
                }
            }
        }
        return INSTANCE;
    }

    @Override
    public void remove() {
        super.remove();
        if (getData() != null && !getData().hasActiveObservers()){
            INSTANCE = null;
        }
    }
}
