/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push.api;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import com.flybits.android.push.db.PushDatabase;
import com.flybits.android.push.deserializations.DeserializePushNotification;
import com.flybits.android.push.exceptions.FlybitsPushException;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.deserializations.IDeserializer;
import java.math.BigDecimal;
import java.util.Map;

public class FlyPushParsing {
    private static final long VERSION = 1L;

    public static Push parsePushNotification(@NonNull Context context, Map bundle) throws FlybitsPushException {
        FlyPushParsing.verifyPushNotificationIsFlybits(bundle);
        Push notification = FlyPushParsing.buildFCMPushNotification(bundle);
        if (notification != null && notification.getId() != null) {
            InsertIntoDB r = new InsertIntoDB(context, notification);
            new Thread(r).start();
        }
        FlyPushParsing.broadcastPush(context, notification);
        return notification;
    }

    public static Push parsePushNotification(@NonNull Context context, Bundle bundle) throws FlybitsPushException {
        FlyPushParsing.verifyPushNotificationIsFlybits(bundle);
        Push notification = FlyPushParsing.buildGCMPushNotification(bundle);
        if (notification != null) {
            InsertIntoDB r = new InsertIntoDB(context, notification);
            new Thread(r).start();
        }
        FlyPushParsing.broadcastPush(context, notification);
        return notification;
    }

    public static void parseMQTTNotification(Context context, String json) throws IllegalArgumentException {
        Push deserializedPushInfo = (Push)new DeserializePushNotification().fromJson(json);
        FlyPushParsing.broadcastPush(context, deserializedPushInfo);
    }

    protected static void verifyPushNotificationIsFlybits(@NonNull Bundle bundle) throws FlybitsPushException {
        if (!(bundle != null && bundle.containsKey("category") && bundle.containsKey("version") && bundle.containsKey("entity"))) {
            throw new FlybitsPushException("An invalid GCM bundle was provided. Make sure that the GCM Bundle follows the Flybits Push Model.");
        }
    }

    protected static void verifyPushNotificationIsFlybits(@NonNull Map map) throws FlybitsPushException {
        if (!(map != null && map.containsKey("category") && map.containsKey("version") && map.containsKey("entity"))) {
            throw new FlybitsPushException("An invalid GCM bundle was provided. Make sure that the GCM Bundle follows the Flybits Push Model.");
        }
    }

    protected static Push buildGCMPushNotification(Bundle bundle) {
        long timestamp = -1L;
        if (bundle.containsKey("timestamp")) {
            BigDecimal bd = new BigDecimal(bundle.getString("timestamp"));
            timestamp = bd.longValue();
        }
        long version = bundle.containsKey("version") ? Long.parseLong(bundle.getString("version")) : -1L;
        String id = bundle.getString("id") != null && bundle.getString("id").length() > 0 ? bundle.getString("id") : null;
        Push push = null;
        if (bundle.getString("alert") != null && bundle.getString("alert").length() != 0 || bundle.getString("title") != null && bundle.getString("title").length() != 0) {
            String alert = bundle.getString("alert") != null && bundle.getString("alert").length() != 0 ? bundle.getString("alert") : null;
            String title = bundle.getString("title") != null && bundle.getString("title").length() != 0 ? bundle.getString("title") : null;
            push = new Push(id, bundle.getString("entity"), bundle.getString("action"), bundle.getString("category"), version, timestamp, title, alert, bundle.getString("body"));
        }
        return push;
    }

    protected static Push buildFCMPushNotification(Map map) {
        long timestamp = -1L;
        if (map.containsKey("timestamp")) {
            BigDecimal bd = new BigDecimal(map.get("timestamp").toString());
            timestamp = bd.longValue();
        }
        long version = map.containsKey("version") ? Long.parseLong(map.get("version").toString()) : -1L;
        String body = map.containsKey("body") ? map.get("body").toString() : null;
        String id = map.containsKey("id") && map.get("id").toString().length() > 0 ? map.get("id").toString() : null;
        Push push = null;
        if (map.containsKey("alert") && map.get("alert").toString().length() != 0 || map.containsKey("title") && map.get("title").toString().length() != 0) {
            String alert = map.containsKey("alert") && map.get("alert").toString().length() != 0 ? map.get("alert").toString() : null;
            String title = map.containsKey("title") && map.get("title").toString().length() != 0 ? map.get("title").toString() : null;
            push = new Push(id, map.get("entity").toString(), map.get("action").toString(), map.get("category").toString(), version, timestamp, title, alert, body);
        }
        return push;
    }

    private static void broadcastPush(Context context, Push push) {
        switch (push.getCategory()) {
            case CONTEXT: {
                FlyPushParsing.decodePushContext(context, push);
                break;
            }
            case KERNEL: {
                FlyPushParsing.decodePushKernel(context, push);
                break;
            }
            case CUSTOM: {
                FlyPushParsing.decodePushCustom(context, push);
            }
        }
    }

    private static <T extends IDeserializer> void decodePushContext(Context context, Push deserializedPushInfo) {
        Intent intentCustom = new Intent("com.flybits.action.push.context");
        intentCustom.putExtra("com.flybits.extra.push", (Parcelable)deserializedPushInfo);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intentCustom);
    }

    private static <T extends IDeserializer> void decodePushKernel(Context context, Push deserializedPushInfo) {
        Intent intentCustom = new Intent("com.flybits.action.push.core");
        intentCustom.putExtra("com.flybits.extra.push", (Parcelable)deserializedPushInfo);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intentCustom);
    }

    private static <T extends IDeserializer> void decodePushCustom(Context context, Push deserializedPushInfo) {
        Intent intentCustom = new Intent("com.flybits.action.push.custom");
        intentCustom.putExtra("com.flybits.extra.push", (Parcelable)deserializedPushInfo);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intentCustom);
    }

    private static class InsertIntoDB
    implements Runnable {
        private Push notification;
        private Context context;

        public InsertIntoDB(Context context, Push notification) {
            this.notification = notification;
            this.context = context;
        }

        @Override
        public void run() {
            PushDatabase.getDatabase(this.context).pushDao().insert(this.notification);
        }
    }
}

