package com.flybits.android.push.deserializations;

import android.support.annotation.NonNull;

import com.flybits.android.push.models.Push;
import com.flybits.commons.library.deserializations.IDeserializer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializePushNotification extends IDeserializer<Push> {

    public DeserializePushNotification() {}

    @Override
    public Push fromJson(JSONObject jObj) {
        try{
            long version        = (!jObj.isNull("version")) ? jObj.getLong("version") : -1;
            long timestamp      = (!jObj.isNull("timestamp")) ? jObj.getLong("timestamp") : -1;
            String message      = (!jObj.isNull("alert")) ? jObj.getString("alert") : null;
            String title        = (!jObj.isNull("title")) ? jObj.getString("title") : null;
            String id           = (!jObj.isNull("id")) ? jObj.getString("id") : null;
            String entity       = (!jObj.isNull("entity")) ? jObj.getString("entity") : "unknown";
            String action       = (!jObj.isNull("action")) ? jObj.getString("action") : "unknown";
            String category     = (!jObj.isNull("category")) ? jObj.getString("category") : "unknown";

            String bodyAsString = null;
            if (!jObj.isNull("body")){

                Object jsonType = jObj.get("body");
                if (jsonType instanceof JSONObject) {
                    bodyAsString = jObj.getJSONObject("body").toString();
                }else if (jsonType instanceof JSONArray) {
                    bodyAsString = jObj.getJSONArray("body").toString();
                }else{
                    bodyAsString = jObj.getString("body");
                }
            }
            return new Push(id, entity, action, category, version, timestamp, title, message, bodyAsString);
        }catch (JSONException exception){}

        return null;
    }

    @Override
    public Push fromJson(JSONArray jsonArray) {
        return null;
    }

    @Override
    public String toJson(@NonNull Push obj) {
        if (obj == null){
            return "{}";
        }

        JSONObject objJson = new JSONObject();

        try {
            objJson.put("id", obj.getId());
        }catch (JSONException e){}

        try {
            objJson.put("version", obj.getVersion());
        }catch (JSONException e){}

        try {
            objJson.put("category", obj.getCategory().getKey());
        }catch (JSONException e){}

        try {
            objJson.put("entity", obj.getEntity().getKey());
        }catch (JSONException e){}

        try {
            objJson.put("action", obj.getAction().getKey());
        }catch (JSONException e){}

        try {
            objJson.put("alert", obj.getMessage());
        }catch (JSONException e){}

        try {
            objJson.put("title", obj.getTitle());
        }catch (JSONException e){}

        try {
            objJson.put("body", obj.getCustomFieldsAsString());
        }catch (JSONException e){}

        return objJson.toString();
    }
}
