/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.flybits.android.push.PushManager;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.User;

public class PushScope
extends FlybitsScope {
    public static final String ROOT = "/push";
    private Context context;
    private String gcmSenderID;
    private PushType type;
    private SharedPreferences flybitsPreferences;

    public PushScope(@NonNull Context context) {
        super("PushScope");
        this.context = context;
        this.type = PushType.FCM;
        this.flybitsPreferences = PushScope.getPushPreferences(context);
    }

    public PushScope(@NonNull Context context, String gcmSenderID) {
        super("PushScope");
        this.context = context;
        this.type = PushType.GCM;
        this.gcmSenderID = gcmSenderID;
        this.flybitsPreferences = PushScope.getPushPreferences(context);
    }

    public void onConnected(User user) {
        switch (this.type) {
            case GCM: {
                PushManager.enableGCMPush(this.context, this.gcmSenderID, new BasicResultCallback(){

                    public void onSuccess() {
                    }

                    public void onException(FlybitsException exception) {
                    }
                });
                break;
            }
            case FCM: {
                PushManager.enableFCMPush(this.context, new BasicResultCallback(){

                    public void onSuccess() {
                    }

                    public void onException(FlybitsException exception) {
                    }
                });
            }
        }
    }

    public void onDisconnected(String jwtToken) {
        PushManager.disablePush(this.context, jwtToken, new BasicResultCallback(){

            public void onSuccess() {
                PushScope.this.clearPushPreferences();
            }

            public void onException(FlybitsException exception) {
            }
        });
    }

    public void onAccountDestroyed(String jwtToken) {
        this.onDisconnected(jwtToken);
    }

    public static SharedPreferences getPushPreferences(Context context) {
        return context.getSharedPreferences("FLYBITS_PREF_PUSH", 0);
    }

    private void clearPushPreferences() {
        SharedPreferences.Editor preferences = PushScope.getPushPreferences(this.context).edit();
        preferences.clear();
        preferences.apply();
    }

    private static enum PushType {
        FCM,
        GCM;

    }
}

