/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.db.converters.JsonParserConverters;
import com.flybits.android.kernel.db.converters.ListStringConverters;
import com.flybits.android.kernel.db.converters.LocalizedValueConverters;
import com.flybits.android.kernel.db.dao.ContentDao;
import com.flybits.android.kernel.db.dao.GroupDao;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.Group;

@Database(entities={Content.class, Group.class}, version=7)
@TypeConverters(value={LocalizedValueConverters.class, ListStringConverters.class, JsonParserConverters.class})
public abstract class KernelDatabase
extends RoomDatabase {
    private static KernelDatabase INSTANCE;
    static final Migration MIGRATION_6_7;
    static final Migration MIGRATION_5_6;
    static final Migration MIGRATION_4_5;
    static final Migration MIGRATION_3_5;
    static final Migration MIGRATION_1_5;

    public abstract ContentDao contentDao();

    public abstract GroupDao groupDao();

    public static KernelDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = (KernelDatabase)Room.databaseBuilder((Context)context, KernelDatabase.class, (String)"flybits-kernel-db").addMigrations(new Migration[]{MIGRATION_1_5, MIGRATION_3_5, MIGRATION_4_5, MIGRATION_5_6, MIGRATION_6_7}).fallbackToDestructiveMigration().build();
        }
        return INSTANCE;
    }

    public static void destroy() {
        INSTANCE = null;
    }

    static {
        MIGRATION_6_7 = new Migration(6, 7){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE content ADD COLUMN experienceId TEXT");
                database.execSQL("ALTER TABLE content ADD COLUMN pushRequestId TEXT");
            }
        };
        MIGRATION_5_6 = new Migration(5, 6){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE content ADD COLUMN evaluatedAt INTEGER NOT NULL DEFAULT -1");
            }
        };
        MIGRATION_4_5 = new Migration(4, 5){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE content ADD COLUMN metadata TEXT");
                database.execSQL("ALTER TABLE content ADD COLUMN isFavourite INTEGER");
            }
        };
        MIGRATION_3_5 = new Migration(3, 5){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE content ADD COLUMN labels TEXT");
                database.execSQL("ALTER TABLE content ADD COLUMN metadata TEXT");
                database.execSQL("ALTER TABLE content ADD COLUMN isFavourite INTEGER");
            }
        };
        MIGRATION_1_5 = new Migration(1, 5){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE content ADD COLUMN labels TEXT");
                database.execSQL("ALTER TABLE content ADD COLUMN type TEXT");
                database.execSQL("ALTER TABLE content ADD COLUMN metadata TEXT");
                database.execSQL("ALTER TABLE content ADD COLUMN isFavourite INTEGER");
            }
        };
    }
}

