/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db.converters;

import android.arch.persistence.room.TypeConverter;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;

public class ListStringConverters {
    @TypeConverter
    public static ArrayList<String> fromString(String json) {
        if (json == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> listOfLabels = new ArrayList<String>();
        try {
            JSONArray object = new JSONArray(json);
            for (int i = 0; i < object.length(); ++i) {
                String value = object.getString(i);
                listOfLabels.add(value);
            }
        }
        catch (JSONException e) {
            return new ArrayList<String>();
        }
        return listOfLabels;
    }

    @TypeConverter
    public static String localizedvalueToString(ArrayList<String> values) {
        if (values == null) {
            return "[]";
        }
        try {
            JSONArray objectArray = new JSONArray();
            for (String value : values) {
                objectArray.put((Object)value);
            }
            return objectArray.toString();
        }
        catch (Exception ex) {
            return "[]";
        }
    }
}

