/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.deserializers;

import android.content.Context;
import com.flybits.android.kernel.deserializers.DeserializeExperience;
import com.flybits.android.kernel.models.Experience;
import com.flybits.android.kernel.models.Group;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeGroup
extends IDeserializer<Group> {
    private Context context;

    public DeserializeGroup(Context context) {
        this.context = context;
    }

    public String toJson(Group group) {
        JSONObject objectLanguageCode2;
        if (group == null) {
            return "{}";
        }
        JSONObject object = new JSONObject();
        try {
            object.put("creatorId", (Object)group.getCreatorId());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JSONObject localizationObject = new JSONObject();
        ArrayList<String> listofCodes = new ArrayList<String>();
        for (String code : group.getNameObject().getListOfSupportedLanguages()) {
            try {
                if (group.getName(code) == null) continue;
                listofCodes.add(code);
                objectLanguageCode2 = new JSONObject();
                objectLanguageCode2.put("name", (Object)group.getName(code));
                localizationObject.put(code, (Object)objectLanguageCode2);
                if (group.getDescription(code) == null) continue;
                objectLanguageCode2.put("description", (Object)group.getDescription(code));
                localizationObject.put(code, (Object)objectLanguageCode2);
            }
            catch (JSONException objectLanguageCode2) {}
        }
        for (String code : group.getDescriptionObject().getListOfSupportedLanguages()) {
            try {
                if (listofCodes.contains(code) || group.getDescription(code) == null) continue;
                objectLanguageCode2 = new JSONObject();
                objectLanguageCode2.put("description", (Object)group.getDescription(code));
                localizationObject.put(code, (Object)objectLanguageCode2);
            }
            catch (JSONException jSONException) {}
        }
        try {
            object.put("localizations", (Object)localizationObject);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    public Group fromJson(JSONObject jsonObject) {
        try {
            if (!(jsonObject.isNull("id") || jsonObject.isNull("tenantId") || jsonObject.isNull("creatorId") || jsonObject.isNull("experiences"))) {
                String id = jsonObject.getString("id");
                String creatorId = jsonObject.getString("creatorId");
                JSONArray experiences = jsonObject.getJSONArray("experiences");
                long createdAt = -1L;
                long modifiedAt = -1L;
                if (!jsonObject.isNull("createdAt")) {
                    createdAt = jsonObject.getLong("createdAt");
                }
                if (!jsonObject.isNull("modifiedAt")) {
                    modifiedAt = jsonObject.getLong("modifiedAt");
                }
                ArrayList<Experience> experienceList = new ArrayList<Experience>();
                DeserializeExperience expDeserializer = new DeserializeExperience(this.context);
                for (int j = 0; j < experiences.length(); ++j) {
                    Experience experience = (Experience)expDeserializer.fromJson(experiences.getJSONObject(j).toString());
                    experienceList.add(experience);
                }
                Group group = new Group(id, creatorId, experienceList, createdAt, modifiedAt, (String)SharedElementsFactory.INSTANCE.get(this.context).getEnabledLanguagesAsArray().get(0));
                if (!jsonObject.isNull("localizations")) {
                    JSONObject localizationObject = jsonObject.getJSONObject("localizations");
                    Iterator languages = localizationObject.keys();
                    while (languages.hasNext()) {
                        String language = (String)languages.next();
                        JSONObject languageObj = localizationObject.getJSONObject(language);
                        if (!languageObj.isNull("description")) {
                            group.setDescription(language, languageObj.getString("description"));
                        }
                        if (languageObj.isNull("name")) continue;
                        group.setName(language, languageObj.getString("name"));
                    }
                }
                return group;
            }
            return null;
        }
        catch (JSONException e) {
            Logger.exception((String)"DeserializeGroup.fromJson", (Exception)((Object)e));
            return null;
        }
    }

    public Group fromJson(JSONArray jsonArray) {
        return null;
    }
}

