package com.flybits.android.kernel.db.converters;

import android.arch.persistence.room.TypeConverter;
import com.flybits.android.kernel.models.LocalizedValue;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;

public class LocalizedValueConverters {

    @TypeConverter
    public static LocalizedValue fromString(String json) {

        if (json == null){
            return new LocalizedValue("en", "en");
        }

        try {
            JSONObject object = new JSONObject(json);
            LocalizedValue localizedValue = new LocalizedValue(
                    object.getString("entityDefaultLanguage"),
                    object.getString("deviceDefaultLanguage"));

            if (!object.isNull("localizations")) {
                JSONObject localizationObject = object.getJSONObject("localizations");
                Iterator<String> languages = localizationObject.keys();
                while (languages.hasNext()) {
                    String language = languages.next();
                    String value = localizationObject.getString(language);
                    localizedValue.addValue(language, value);
                }
            }

            return localizedValue;
        } catch (JSONException e) {
            return new LocalizedValue("en", "en");
        }
    }

    @TypeConverter
    public static String localizedvalueToString(LocalizedValue value) {

        if (value == null){
            return "";
        }

        try{
            JSONObject object = new JSONObject();
            object.put("entityDefaultLanguage", value.getEntityDefaultLanguage());
            object.put("deviceDefaultLanguage", value.getDeviceLanguage());
            JSONObject localizationObject = new JSONObject();

            for (String language : value.getListOfSupportedLanguages()){
                localizationObject.put(language, value.getValue(language));
            }

            object.put("localizations", localizationObject);
            return object.toString();
        } catch (JSONException e) {
            return "";
        }
    }

}
