package com.flybits.android.kernel.exceptions

import com.flybits.commons.library.exceptions.FlybitsException

/**
 * The exception is thrown when the calling getData on a specific Content instance. This happens when
 * the incoming JSON that represents the Content Data is attempted to be parsing into the class. For
 * example, if you have a JSON object {} and you are trying to parse it into the a List<String>
 * object. In order to avoid this exception, make sure your JSON attribute types match the variable
 * definitions inside your [Content] Data class
 *
 * @param fieldName The name of the attribute that caused the exception.
 */
class ParsingContentDataException (fieldName : String) : FlybitsException("You are trying to deserialize the fieldName - $fieldName - " +
                                        "to a variable type that does not match the incoming JSON. Please look at the returned JSON " +
                                        "to make sure your variable type matches.")