package com.flybits.android.kernel.models.results;

import android.content.Context;
import android.os.Handler;
import com.flybits.android.kernel.models.Group;
import com.flybits.android.kernel.utilities.GroupParameters;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ExecutorService;

public class GroupResult extends PagedResult<Group> {


    public GroupResult(Context context, QueryParameters params, PagedResultCallback<Group> callback, ExecutorService service, Handler handler){
        super(context, params, callback, handler, service);
    }

    @Override
    public <K extends QueryParameters> void getMoreRequest(@NotNull K k, @NotNull PagedResultCallback<Group> pagedResultCallback) {
        Group.get(getContext(), (GroupParameters) k, pagedResultCallback);
    }
}
