package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.content.Context;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * This class is instantiated whenever a user will be sending survey answers to the server. The result
 * id and a list of {@code Answer} objects are provided when constructing. The resulting data then can
 * be sent to the server using the {@code saveSurveyAnswers} method.
 */

public class SurveyAnswer {

    public String surveyId;
    public ArrayList<Answer> answers;

    /**
     * Instantiates a {@code SurveyAnswer} object.
     * @param resultId The id given from the
     * @param answers A list of {@code Answer} objects that contain the chosen answers from the user.
     */
    public SurveyAnswer(String resultId, ArrayList<Answer> answers) {
        this.surveyId = resultId;
        this.answers = answers;
    }

    /**
     * Serializes the {@code SurveyAnswer} object into JSON.
     * @return This object as JSON read to be sent to the server.
     * @throws JSONException When something has gone wrong in serialization.
     */
    public String getJSON() throws JSONException
    {
        JSONObject root = new JSONObject();
        JSONArray answersArray = new JSONArray();

        root.put("surveyId", surveyId);
        root.put("answers", answersArray);

        for (Answer answer : answers)
        {
            JSONObject answerObject = new JSONObject(answer.getJSON());
            answersArray.put(answerObject);
        }

        return root.toString();
    }

    /**
     * Sends this object's data to the server.
     * @param context The context of the application.
     * @param surveyContentInstance The
     * @param callback A result callback
     * @return A {@code BasicResult} object.
     */
    public BasicResult saveSurveyAnswers(Context context, Content surveyContentInstance, BasicResultCallback callback) {
        return surveyContentInstance.saveData(context, this, callback);
    }

}
