package com.flybits.android.kernel.db.converters;

import android.arch.persistence.room.TypeConverter;
import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;

public class ListStringConverters {

    @TypeConverter
    public static ArrayList<String> fromString(String json) {

        if (json == null){
            return new ArrayList<>();
        }

        ArrayList<String> listOfLabels  = new ArrayList<>();
        try {
            JSONArray object = new JSONArray(json);
            for (int i = 0; i < object.length(); i++) {
                String value    = object.getString(i);
                listOfLabels.add(value);
            }
        } catch (JSONException e) {
            return new ArrayList<>();
        }
        return listOfLabels;
    }

    @TypeConverter
    public static String localizedvalueToString(ArrayList<String> values) {

        if (values == null){
            return "[]";
        }


        try {
            JSONArray objectArray = new JSONArray();
            for (String value : values) {
                objectArray.put(value);
            }
            return objectArray.toString();
        }catch (Exception ex){
            return "[]";
        }
    }
}
