package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.android.kernel.models.LocalizedValue;

/**
 * This POJO defines the options a user can choose from in a {@code Question} when requesting the
 * data from a {@code SurveyQuestion} content instance.
 */

public class QuestionChoice implements Parcelable
{

    public String key;
    public LocalizedValue value;
    public String metadata;

    public QuestionChoice(){}

    protected QuestionChoice(Parcel in)
    {
        key = in.readString();
        value = in.readParcelable(LocalizedValue.class.getClassLoader());
        metadata = in.readString();
    }

    public static final Creator<QuestionChoice> CREATOR = new Creator<QuestionChoice>()
    {
        @Override
        public QuestionChoice createFromParcel(Parcel in)
        {
            return new QuestionChoice(in);
        }

        @Override
        public QuestionChoice[] newArray(int size)
        {
            return new QuestionChoice[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeString(key);
        dest.writeParcelable(value, flags);
        dest.writeString(metadata);
    }
}
