/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import androidx.annotation.NonNull;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import java.util.ArrayList;
import java.util.Map;

public class ContentParameters
extends QueryParameters {
    private String locId;
    private double latitude;
    private double longitude;
    private double radius;
    private String url;
    private String templateId;
    private String templateType;
    private String groupId;

    private ContentParameters(Builder builder) {
        super((QueryBuilder)builder);
        this.templateId = builder.templateId;
        this.templateType = builder.templateType;
        this.locId = builder.locId;
        if (this.locId != null) {
            this.latitude = builder.latitude;
            this.longitude = builder.longitude;
            this.radius = builder.radius;
        }
        if (builder.experienceId != null) {
            this.url = String.format("/kernel/experiences/%s/contents", builder.experienceId);
        } else if (this.locId != null || this.templateId != null) {
            this.url = "/kernel/content/instances";
        } else {
            this.url = "/kernel/experiences/contents";
            this.groupId = builder.groupId;
        }
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        Map params = super.getQueryParams();
        if (this.locId != null) {
            ArrayList<String> latitudeParam = new ArrayList<String>();
            latitudeParam.add(String.valueOf(this.latitude));
            params.put("lat", latitudeParam);
            ArrayList<String> longitudeParam = new ArrayList<String>();
            longitudeParam.add(String.valueOf(this.longitude));
            params.put("lng", longitudeParam);
            ArrayList<String> radiusParam = new ArrayList<String>();
            radiusParam.add(String.valueOf(this.radius));
            params.put("radius", radiusParam);
            ArrayList<String> locParam = new ArrayList<String>();
            locParam.add(String.valueOf(this.locId));
            params.put("loc", locParam);
        }
        if (this.templateId != null) {
            ArrayList<String> templateIdParam = new ArrayList<String>();
            templateIdParam.add(String.valueOf(this.templateId));
            params.put("templateId", templateIdParam);
        }
        if (this.templateType != null) {
            ArrayList<String> templateTypeParam = new ArrayList<String>();
            templateTypeParam.add(String.valueOf(this.templateType));
            params.put("templateType", templateTypeParam);
        }
        if (this.groupId != null) {
            ArrayList<String> groupIdParam = new ArrayList<String>();
            groupIdParam.add(this.groupId);
            params.put("groupId", groupIdParam);
        }
        ArrayList<String> dataParam = new ArrayList<String>();
        dataParam.add(String.valueOf(true));
        params.put("data", dataParam);
        return params;
    }

    public String getUrl() {
        return this.url;
    }

    public static class Builder
    extends QueryBuilder<Builder> {
        private String locId;
        private double latitude;
        private double longitude;
        private double radius;
        private String templateId;
        private String templateType;
        private String experienceId;
        private String groupId;

        public Builder setCaching(@NonNull String cachingKey, int limit) {
            super.setCaching(cachingKey, limit);
            return this;
        }

        public Builder setExperienceId(@NonNull String id) {
            this.experienceId = id;
            return this;
        }

        public Builder setGroupId(@NonNull String id) {
            this.groupId = id;
            return this;
        }

        public Builder setLocation(@NonNull String loc, double latitude, double longitude, long radius) {
            return this.setLocation(loc, latitude, longitude, radius, null);
        }

        public Builder setLocation(@NonNull String loc, double latitude, double longitude, long radius, String templateId) {
            this.locId = loc;
            this.latitude = latitude;
            this.longitude = longitude;
            this.radius = radius;
            this.templateId = templateId;
            return this;
        }

        @Deprecated
        public Builder setTemplateId(@NonNull String id) {
            this.templateId = id;
            return this;
        }

        public Builder setTemplateType(@NonNull String type) {
            this.templateType = type;
            return this;
        }

        public ContentParameters build() throws RuntimeException {
            if (this.locId != null && this.experienceId != null) {
                throw new RuntimeException("Currently joining the setExperienceId(...) and setLocation(...) methods is not supported. You must choose one or the other to build a valid ContentParameters object");
            }
            if (this.locId != null && this.groupId != null) {
                throw new RuntimeException("Currently joining the setGroupId(...) and setLocation(...) methods is not supported. You must choose one or the other to build a valid ContentParameters object");
            }
            if (this.experienceId != null && this.groupId != null) {
                throw new RuntimeException("Currently joining the setGroupId(...) and setExperienceId(...) methods is not supported. You must choose one or the other to build a valid ContentParameters object");
            }
            return new ContentParameters(this);
        }
    }
}

