/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;

public class LocationData
implements Parcelable {
    private double lat;
    private double lng;
    private double distance;
    private String address;
    public static final Parcelable.Creator<LocationData> CREATOR = new Parcelable.Creator<LocationData>(){

        public LocationData createFromParcel(Parcel in) {
            return new LocationData(in);
        }

        public LocationData[] newArray(int size) {
            return new LocationData[size];
        }
    };

    public LocationData(double lat, double lng, double distance, String address) {
        this.lat = lat;
        this.lng = lng;
        this.distance = distance;
        this.address = address;
    }

    public LocationData(Parcel in) {
        this.lat = in.readDouble();
        this.lng = in.readDouble();
        this.distance = in.readDouble();
        this.address = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.lat);
        dest.writeDouble(this.lng);
        dest.writeDouble(this.distance);
        dest.writeString(this.address);
    }

    @Nullable
    public String getAddress() {
        return this.address;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public static enum Unit {
        METRES{

            @Override
            public double toFeet(double distance) {
                return distance * 3.28084;
            }

            @Override
            public double toKilometres(double distance) {
                return distance * 0.001;
            }

            @Override
            public double toMiles(double distance) {
                return distance * 6.21371E-4;
            }

            @Override
            public double toMetres(double distance) {
                return distance * 1.0;
            }
        }
        ,
        FEET{

            @Override
            public double toMetres(double distance) {
                return distance / 3.28084;
            }

            @Override
            public double toKilometres(double distance) {
                return this.toMetres(distance) * 0.001;
            }

            @Override
            public double toMiles(double distance) {
                return this.toMetres(distance) * 6.21371E-4;
            }

            @Override
            public double toFeet(double distance) {
                return distance;
            }
        }
        ,
        KILOMETRES{

            @Override
            public double toMetres(double distance) {
                return distance / 0.001;
            }

            @Override
            public double toFeet(double distance) {
                return this.toMetres(distance) * 3.28084;
            }

            @Override
            public double toMiles(double distance) {
                return this.toMetres(distance) * 6.21371E-4;
            }

            @Override
            public double toKilometres(double distance) {
                return distance;
            }
        }
        ,
        MILES{

            @Override
            public double toMetres(double distance) {
                return distance / 6.21371E-4;
            }

            @Override
            public double toFeet(double distance) {
                return this.toMetres(distance) * 3.28084;
            }

            @Override
            public double toKilometres(double distance) {
                return this.toMetres(distance) * 0.001;
            }

            @Override
            public double toMiles(double distance) {
                return distance;
            }
        };

        private static final double METRES_VALUE = 1.0;
        private static final double FEET_VALUE = 3.28084;
        private static final double KILOMETRES_VALUE = 0.001;
        private static final double MILES_VALUE = 6.21371E-4;

        public abstract double toFeet(double var1);

        public abstract double toKilometres(double var1);

        public abstract double toMetres(double var1);

        public abstract double toMiles(double var1);
    }
}

