/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db.caching;

import android.content.Context;
import androidx.annotation.NonNull;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.models.Group;
import com.flybits.commons.library.caching.FlybitsUIListObserver;
import java.util.List;

public class GroupCacheObserver
extends FlybitsUIListObserver<Group> {
    private static GroupCacheObserver INSTANCE = null;

    private GroupCacheObserver(Context context) {
        super(context);
    }

    public void onLoad(List<String> cachingIds) {
        this.setItems(KernelDatabase.getDatabase(this.getContext()).groupDao().getLiveByCacheIds(cachingIds));
    }

    public void add(@NonNull String key, FlybitsUIListObserver.DataChanged<Group> callback) {
        super.add(key, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupCacheObserver observe(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<GroupCacheObserver> clazz = GroupCacheObserver.class;
        synchronized (GroupCacheObserver.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new GroupCacheObserver(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void remove() {
        super.remove();
        if (this.getData() != null && !this.getData().hasActiveObservers()) {
            INSTANCE = null;
        }
    }
}

