package com.flybits.android.kernel.db.dao;

import androidx.room.Insert;
import androidx.room.Query;
import com.flybits.android.kernel.models.Experience;

import java.util.List;

import static androidx.room.OnConflictStrategy.REPLACE;

public interface ExperienceDao {

    @Query("SELECT * FROM experiences")
    List<Experience> getAll();

    @Query("SELECT * FROM experiences WHERE id = :id")
    Experience getById(String id);

    @Insert(onConflict = REPLACE)
    void insertOrReplaceNewExperience(List<Experience> experiences);

    @Query("DELETE FROM experiences")
    void clear();
}
