/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.models;

import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.flybits.android.kernel.api.FlyContentData;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.deserializers.DeserializeContentDatum;
import com.flybits.android.kernel.deserializers.DeserializeContentInstance;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.SurveyMetadata;
import com.flybits.android.kernel.models.internal.ContentDataResponse;
import com.flybits.android.kernel.models.results.ContentResult;
import com.flybits.android.kernel.utilities.ContentDataParameters;
import com.flybits.android.kernel.utilities.ContentDataSerializer;
import com.flybits.android.kernel.utilities.ContentParameters;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ListResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ListResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializeListResponse;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.JsonParser;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.internal.SortByEnumeratable;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.CachingEntry;
import com.flybits.internal.models.preferences.FlybitsFavourite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(tableName="content")
public class Content
implements Parcelable {
    public static final String FAVOURITE_KEY = "ContentFavourite";
    public static final String API_CONTENT_RELEVANT_INSTANCES = "/kernel/experiences/contents";
    public static final String API_CONTENT_INSTANCE = "/kernel/content/instances";
    public static final String API_CONTENT_INSTANCE_VIA_EXPERIENCE = "/kernel/experiences/%s/contents";
    public static final String API_CONTENT_INSTANCE_WITHDATA = "/kernel/content/instances/%s?data=true";
    @PrimaryKey
    @NonNull
    private String id;
    private String templateId;
    private LocalizedValue nameObject;
    private LocalizedValue descriptionObject;
    private long createdAt;
    private long modifiedAt;
    private String icon;
    private String dataAsJson;
    private String type;
    private JsonParser metadata;
    private boolean isFavourite;
    @Ignore
    private Parcelable deserializedObject;
    private ArrayList<String> labels;
    public static final Parcelable.Creator<Content> CREATOR = new Parcelable.Creator<Content>(){

        public Content createFromParcel(Parcel in) {
            return new Content(in);
        }

        public Content[] newArray(int size) {
            return new Content[size];
        }
    };

    public Content() {
    }

    @Deprecated
    @Ignore
    private Content(@NonNull String id, @NonNull String templateId, String iconUrl, @NonNull String defaultLanguage, @NonNull String defaultDeviceLangauge, long createdAt, long modifiedAt, ArrayList<String> labels) {
        this(id, templateId, iconUrl, defaultLanguage, defaultDeviceLangauge, createdAt, modifiedAt, labels, "");
    }

    @Ignore
    private Content(@NonNull String id, @NonNull String templateId, String iconUrl, @NonNull String defaultLanguage, @NonNull String defaultDeviceLangauge, long createdAt, long modifiedAt, ArrayList<String> labels, String type) {
        this.id = id;
        this.templateId = templateId;
        this.icon = iconUrl;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.nameObject = new LocalizedValue(defaultLanguage, defaultDeviceLangauge);
        this.descriptionObject = new LocalizedValue(defaultLanguage, defaultDeviceLangauge);
        this.labels = labels;
        this.type = type;
    }

    @Ignore
    protected Content(Parcel in) {
        this(in.readString(), in.readString(), in.readString(), in.readString(), in.readString(), in.readLong(), in.readLong(), in.createStringArrayList(), in.readString());
        this.nameObject = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.descriptionObject = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        try {
            this.metadata = new SurveyMetadata(new JSONObject(in.readString()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (in.readInt() == 1) {
            this.dataAsJson = in.readString();
        }
        if (in.readInt() == 1) {
            this.deserializedObject = in.readParcelable(Parcelable.class.getClassLoader());
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.templateId);
        dest.writeString(this.icon);
        dest.writeString(this.nameObject.getEntityDefaultLanguage());
        dest.writeString(this.nameObject.getDeviceDefaultLanguage());
        dest.writeLong(this.createdAt);
        dest.writeLong(this.modifiedAt);
        dest.writeStringList(this.labels);
        dest.writeString(this.type);
        dest.writeParcelable((Parcelable)this.nameObject, flags);
        dest.writeParcelable((Parcelable)this.descriptionObject, flags);
        dest.writeString(this.metadata != null ? this.metadata.toJson().toString() : "");
        dest.writeInt(this.dataAsJson != null ? 1 : 0);
        if (this.dataAsJson != null) {
            dest.writeString(this.dataAsJson);
        }
        dest.writeInt(this.deserializedObject != null ? 1 : 0);
        if (this.deserializedObject != null) {
            dest.writeParcelable(this.deserializedObject, flags);
        }
    }

    @Deprecated
    public Content(@NonNull String id, @NonNull String templateId, String iconUrl, @NonNull String defaultLanguage, @NonNull String defaultDeviceLangauge, long createdAt, long modifiedAt, @NonNull String dataJson, ArrayList<String> labels) {
        this(id, templateId, iconUrl, defaultLanguage, defaultDeviceLangauge, createdAt, modifiedAt, labels, "");
        this.dataAsJson = dataJson;
    }

    public Content(@NonNull String id, @NonNull String templateId, String iconUrl, @NonNull String defaultLanguage, @NonNull String defaultDeviceLangauge, long createdAt, long modifiedAt, @NonNull String dataJson, ArrayList<String> labels, String type) {
        this(id, templateId, iconUrl, defaultLanguage, defaultDeviceLangauge, createdAt, modifiedAt, labels, type);
        this.dataAsJson = dataJson;
    }

    private void changeFavourite(Context context, boolean isFavourite, BasicResultCallback callback) {
        FlybitsFavourite favourite = new FlybitsFavourite(context);
        if (callback == null) {
            callback = new BasicResultCallback(){

                public void onSuccess() {
                }

                public void onException(FlybitsException exception) {
                }
            };
        }
        if (isFavourite) {
            favourite.add(FAVOURITE_KEY, this.getId(), callback);
        } else {
            favourite.remove(FAVOURITE_KEY, this.getId(), callback);
        }
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getDataAsJson() {
        return this.dataAsJson;
    }

    public String getDescription() {
        return this.descriptionObject.getValue();
    }

    public String getDescription(String langauge) {
        return this.descriptionObject.getValue(langauge);
    }

    public LocalizedValue getDescriptionObject() {
        return this.descriptionObject;
    }

    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public boolean getIsFavourite() {
        return this.isFavourite;
    }

    public ArrayList<String> getLabels() {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        return this.labels;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public String getName() {
        return this.nameObject.getValue();
    }

    public String getName(String language) {
        return this.nameObject.getValue(language);
    }

    public LocalizedValue getNameObject() {
        return this.nameObject;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getType() {
        return this.type;
    }

    public JsonParser getMetadata() {
        return this.metadata;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setDataAsJson(String dataAsJson) {
        this.dataAsJson = dataAsJson;
    }

    public void setDescription(@NonNull String languageCode, @NonNull String description) {
        this.descriptionObject.addValue(languageCode, description);
    }

    public void setDescriptionObject(LocalizedValue value) {
        this.descriptionObject = value;
    }

    public void setIsFavourite(boolean isFavourite) {
        this.isFavourite = isFavourite;
    }

    public void setFavourite(Context context, BasicResultCallback callback) {
        this.changeFavourite(context, true, callback);
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setId(@NonNull String id) {
        this.id = id;
    }

    public void setLabels(@NonNull ArrayList<String> labels) {
        this.labels = labels;
    }

    public void setModifiedAt(long modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public void setName(@NonNull String languageCode, @NonNull String name) {
        this.nameObject.addValue(languageCode, name);
    }

    public void setNameObject(LocalizedValue value) {
        this.nameObject = value;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void unsetFavourite(Context context, BasicResultCallback callback) {
        this.changeFavourite(context, false, callback);
    }

    public void setMetadata(JsonParser metadata) {
        this.metadata = metadata;
    }

    @Nullable
    public <T extends Parcelable> T getData(Context context, @Nullable Class modelClass) throws FlybitsException {
        if (this.deserializedObject != null) {
            return (T)this.deserializedObject;
        }
        if (modelClass == null) {
            return null;
        }
        ContentDataResponse response = new DeserializeContentDatum(context, this.id, modelClass).fromJson(this.dataAsJson);
        if (response == null) {
            throw new FlybitsException("It appears that the modelClass that you provided as the second parameter of the getData(...) method does not match the JSON coming from the Flybits Experience Studio. Please verify that the two are the same. If your application is crashing, make sure you surround your getData(...) method call with a try-catch.");
        }
        ArrayList root = response.getItems();
        if (root != null && root.size() != 0) {
            this.deserializedObject = (Parcelable)root.get(0);
        }
        return (T)this.deserializedObject;
    }

    public void clearDeserializedObject() {
        this.deserializedObject = null;
    }

    public static ListResult<Content> get(final @NonNull Context context, final @NonNull Collection<String> ids, ListResultCallback<Content> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ListResult result = new ListResult(callback, handler, executorService);
        if (ids.size() == 0) {
            result.setSuccess(new ArrayList());
            return result;
        }
        if (ids.size() > 50) {
            throw new IllegalArgumentException("The size of your ids parameters must be less than 50. If you need to get more than 50 Content consider using multiple requests.");
        }
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    StringBuilder url = new StringBuilder("/kernel/content/instances?data=true&contentIds=");
                    url.append(TextUtils.join((CharSequence)",", (Iterable)ids));
                    DeserializeContentInstance singleDeserializer = new DeserializeContentInstance(context);
                    DeserializeListResponse deserializer = new DeserializeListResponse((IDeserializer)singleDeserializer);
                    Result resultGetInstances = FlyAway.get((Context)context, (String)url.toString(), null, (Map)null, (IDeserializer)deserializer, (String)"Content.getMultipleIds");
                    List listOfStoredIds = CommonsDatabase.getDatabase((Context)context).preferenceDAO().getIdsByKey(Content.FAVOURITE_KEY);
                    if (listOfStoredIds.size() > 0 && resultGetInstances != null && resultGetInstances.getResult() != null) {
                        for (Content item : (ArrayList)resultGetInstances.getResult()) {
                            item.setIsFavourite(listOfStoredIds.contains(item.getId()));
                        }
                    }
                    result.setResult(resultGetInstances);
                }
                catch (FlybitsException e) {
                    result.setFailed(e);
                }
            }
        });
        return result;
    }

    public static ContentResult get(final @NonNull Context context, final @NonNull ContentParameters params, PagedResultCallback<Content> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ContentResult result = new ContentResult(context, params, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = params.getUrl();
                    DeserializeContentInstance singleDeserializer = new DeserializeContentInstance(context);
                    DeserializePagedResponse deserializer = new DeserializePagedResponse((IDeserializer)singleDeserializer);
                    Result resultGetInstances = FlyAway.get((Context)context, (String)url, (QueryParameters)params, (IDeserializer)deserializer, (String)"Content.get");
                    List listOfIds = null;
                    if (resultGetInstances.getStatus() == RequestStatus.COMPLETED) {
                        List listOfStoredIds;
                        int maxNumberOfRecordsToSave;
                        if ((params.getQueryParams().get("offset") == null || params.getQueryParams().get("offset").size() == 0 || params.getQueryParams().get("offset").get(0).equals("0")) && params.getCachingKey() != null) {
                            listOfIds = CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().getUniqueIdsByCachingKey(params.getCachingKey());
                        }
                        int n = maxNumberOfRecordsToSave = (long)params.getCachingLimit() < (long)((PagedResponse)resultGetInstances.getResult()).getItems().size() + ((PagedResponse)resultGetInstances.getResult()).getPagination().getOffset() ? params.getCachingLimit() : ((PagedResponse)resultGetInstances.getResult()).getItems().size();
                        if (params.getCachingKey() != null) {
                            ArrayList<CachingEntry> entries = new ArrayList<CachingEntry>();
                            ArrayList<Content> contentToCache = new ArrayList<Content>();
                            if (resultGetInstances.getResult() != null && ((PagedResponse)resultGetInstances.getResult()).getItems() != null) {
                                for (int i = 0; i < ((PagedResponse)resultGetInstances.getResult()).getItems().size() && i < maxNumberOfRecordsToSave; ++i) {
                                    contentToCache.add((Content)((PagedResponse)resultGetInstances.getResult()).getItems().get(i));
                                    entries.add(new CachingEntry(params.getCachingKey(), ((Content)((PagedResponse)resultGetInstances.getResult()).getItems().get(i)).getId()));
                                }
                            }
                            if (listOfIds != null) {
                                KernelDatabase.getDatabase(context).contentDao().insertAndDeleteInTransaction(listOfIds, contentToCache);
                                CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().deleteAllByCachingKey(params.getCachingKey());
                            } else {
                                KernelDatabase.getDatabase(context).contentDao().insert(contentToCache);
                            }
                            CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().insert(entries);
                        }
                        if ((listOfStoredIds = CommonsDatabase.getDatabase((Context)context).preferenceDAO().getIdsByKey(Content.FAVOURITE_KEY)).size() > 0 && resultGetInstances.getResult() != null && ((PagedResponse)resultGetInstances.getResult()).getItems() != null) {
                            for (Content item : ((PagedResponse)resultGetInstances.getResult()).getItems()) {
                                item.setIsFavourite(listOfStoredIds.contains(item.getId()));
                            }
                        }
                    }
                    result.setResult(resultGetInstances);
                }
                catch (FlybitsException e) {
                    result.setResult(new Result(e, "Content.get failed"));
                }
            }
        });
        return result;
    }

    public static ListResult<Content> getFavourites(final @NonNull Context context, final ListResultCallback<Content> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ListResult result = new ListResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                List listOfStoredIds = CommonsDatabase.getDatabase((Context)context).preferenceDAO().getIdsByKey(Content.FAVOURITE_KEY);
                HashSet<String> setOfContentIds = new HashSet<String>(listOfStoredIds);
                Content.get(context, setOfContentIds, (ListResultCallback<Content>)callback);
            }
        });
        return result;
    }

    public static ObjectResult<Content> getById(final Context context, final String id, ObjectResultCallback<Content> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult result = new ObjectResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = String.format(Content.API_CONTENT_INSTANCE_WITHDATA, id);
                    DeserializeContentInstance singleDeserializer = new DeserializeContentInstance(context);
                    Result resultGetInstance = FlyAway.get((Context)context, (String)url, (IDeserializer)singleDeserializer, (String)"Content.getbyid", Content.class);
                    List listOfStoredPreferences = CommonsDatabase.getDatabase((Context)context).preferenceDAO().getIdsByKeyAndValue(Content.FAVOURITE_KEY, id);
                    if (listOfStoredPreferences.size() > 0 && resultGetInstance != null && resultGetInstance.getResult() != null) {
                        ((Content)resultGetInstance.getResult()).setIsFavourite(true);
                    }
                    result.setResult(resultGetInstance);
                }
                catch (FlybitsException e) {
                    result.setFailed(e);
                }
            }
        });
        return result;
    }

    public static ContentResult get(Context context, ContentParameters params) {
        return Content.get(context, params, null);
    }

    public static <T> ObjectResult<ContentDataResponse<T>> getData(final Context context, final ContentDataParameters params, final Class<T> classObj, ObjectResultCallback<ContentDataResponse<T>> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult result = new ObjectResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Result resultGetInstances = FlyContentData.get(context, params, classObj);
                    result.setResult(resultGetInstances);
                }
                catch (FlybitsException e) {
                    result.setFailed(e);
                }
            }
        });
        return result;
    }

    public BasicResult saveData(final @NonNull Context context, final @NonNull Object objectToSave, @NonNull BasicResultCallback callback) {
        if (context == null) {
            throw new IllegalArgumentException("The context parameter must not be null.");
        }
        if (objectToSave == null) {
            throw new IllegalArgumentException("The object being saved must not be null.");
        }
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String json = ContentDataSerializer.serialize(objectToSave);
                    Result resultPostData = FlyContentData.post(context, Content.this, json);
                    request.setResult(resultPostData);
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        return String.format(Locale.getDefault(), "{id: %s, templateId: %s, nameObject: %s, descriptionObject: %s, createdAt: %d, modifiedAt: %d, icon: %s type: %s, isFavourite: %s}", this.id, this.templateId, this.nameObject, this.descriptionObject, this.createdAt, this.modifiedAt, this.icon, this.type, this.isFavourite);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Content) {
            Content otherContent = (Content)obj;
            String otherTemplateId = otherContent.getTemplateId();
            LocalizedValue otherNameObject = otherContent.getNameObject();
            LocalizedValue otherDescriptionObject = otherContent.getDescriptionObject();
            long otherCreatedAt = otherContent.getCreatedAt();
            long otherModifiedAt = otherContent.getModifiedAt();
            String otherIcon = otherContent.getIcon();
            String otherType = otherContent.getType();
            JsonParser otherMetaData = otherContent.getMetadata();
            ArrayList<String> labelsOther = otherContent.getLabels();
            return otherContent.getId().equals(this.id) && (otherTemplateId == null && this.templateId == null || otherTemplateId != null && otherTemplateId.equals(this.templateId)) && (otherNameObject == null && this.nameObject == null || otherNameObject != null && otherNameObject.equals(this.nameObject)) && (otherDescriptionObject == null && this.descriptionObject == null || otherDescriptionObject != null && otherDescriptionObject.equals(this.descriptionObject)) && otherCreatedAt == this.createdAt && otherModifiedAt == this.modifiedAt && (otherIcon == null && this.icon == null || otherIcon != null && otherIcon.equals(this.icon)) && (otherType == null && this.type == null || otherType != null && otherType.equals(this.type)) && new HashSet<String>(labelsOther).equals(new HashSet<String>(this.getLabels())) && (otherMetaData == null && this.metadata == null || otherMetaData != null && otherMetaData.toJson().equals(this.metadata.toJson()));
        }
        return false;
    }

    public static enum SortBy implements SortByEnumeratable
    {
        PRIORITY("index"),
        EVALUATED_AT("evaluatedAt"),
        CREATED_AT("createdAt"),
        MODIFIED_AT("modifiedAt");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.toString();
        }

        public static SortBy fromValue(String key) {
            for (SortBy type : SortBy.values()) {
                if (!type.getValue().equalsIgnoreCase(key)) continue;
                return type;
            }
            return CREATED_AT;
        }
    }
}

