package com.flybits.android.kernel.workers;

import android.content.Context;
import android.support.annotation.NonNull;

import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.Preference;
import com.flybits.internal.models.preferences.FlybitsFavourite;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import androidx.work.Worker;
import androidx.work.WorkerParameters;

public class FavouritesSyncWorker extends Worker {

    public static final String FLYBITS_PREF_FAVS_TIMESTAMP = "favsRefreshTime";

    public FavouritesSyncWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    @Override
    public Result doWork() {

        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final FlybitsFavourite favourites          = new FlybitsFavourite(getApplicationContext());

        favourites.getFromServer(Content.FAVOURITE_KEY, new ObjectResultCallback<ArrayList<String>>() {
            @Override
            public void onSuccess(final ArrayList<String> items) {

                executorService.execute(new Runnable() {
                    @Override
                    public void run() {
                        ArrayList<Preference> listOfFlybitsPreferences  = new ArrayList<>();
                        for (String item : items){
                            listOfFlybitsPreferences.add(new Preference(Content.FAVOURITE_KEY, item));
                        }

                        CommonsDatabase.getDatabase(getApplicationContext()).preferenceDAO().deleteByPrefKey(FLYBITS_PREF_FAVS_TIMESTAMP);
                        CommonsDatabase.getDatabase(getApplicationContext()).preferenceDAO().insert(listOfFlybitsPreferences);
                        countDownLatch.countDown();
                    }
                });
            }

            @Override
            public void onException(FlybitsException exception) {}
        });


        try {
            if (!countDownLatch.await(5, TimeUnit.SECONDS)){
                return Result.retry();
            }
        } catch (InterruptedException e) {
            return Result.retry();
        }

        return Result.success();
    }
}
