package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * A POJO containing the resulting number of votes for a single choice question. Contained by
 * {@code Result} when requesting data from a {@code SurveyResult} content instance.
 */

public class ResultChoice implements Parcelable
{

    public String key;
    public Long votes;

    public ResultChoice(){}

    protected ResultChoice(Parcel in) {
        key = in.readString();
        votes = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(key);
        dest.writeLong(votes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ResultChoice> CREATOR = new Creator<ResultChoice>() {
        @Override
        public ResultChoice createFromParcel(Parcel in) {
            return new ResultChoice(in);
        }

        @Override
        public ResultChoice[] newArray(int size) {
            return new ResultChoice[size];
        }
    };
}
