/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import android.content.Context;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.LocationData;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.android.kernel.utilities.FieldHelper;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentDataDeserializer {
    public static <T> T deserialize(Context context, String instanceId, @NonNull Class model, String json) throws FlybitsException {
        Constructor contentDataConstructor = null;
        try {
            contentDataConstructor = model.getDeclaredConstructor(new Class[0]);
            contentDataConstructor.setAccessible(true);
            Object contentDataObj = contentDataConstructor.newInstance(new Object[0]);
            JSONObject object = new JSONObject(json);
            ContentDataDeserializer.deserializeObject(context, instanceId, model, contentDataObj, object, "");
            return contentDataObj;
        }
        catch (NoSuchMethodException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (InvocationTargetException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (IllegalAccessException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (InstantiationException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (NullPointerException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (JSONException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)((Object)e));
            throw new FlybitsException("ContentDataDeserializer.MALFORMED_JSON");
        }
    }

    static <T> void deserializeObject(Context context, String instanceId, Class model, T contentDataObj, JSONObject object, String pathSoFar) throws FlybitsException {
        Class superClass = model.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            ContentDataDeserializer.deserializeObject(context, instanceId, superClass, contentDataObj, object, pathSoFar);
        }
        for (Field f : model.getDeclaredFields()) {
            f.setAccessible(true);
            if (FieldHelper.isIgnored(f)) continue;
            if (FieldHelper.isContentIdField(f)) {
                if (!FieldHelper.isString(f.getType())) {
                    FlybitsException exception = new FlybitsException("ContentDataDeserializer.deserializeObject.CONTENT_ID_FIELD_NOT_TYPE_STRING");
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject()", (Exception)((Object)exception));
                    throw new FlybitsException((Throwable)exception);
                }
                try {
                    f.set(contentDataObj, instanceId);
                }
                catch (IllegalAccessException e) {
                    FlybitsException exception = new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_SET_CONTENT_ID_FIELD");
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject()", (Exception)((Object)exception));
                    throw exception;
                }
            }
            String fieldName = FieldHelper.getFieldName(f);
            if (!LocalizedValue.class.isAssignableFrom(f.getType()) && !object.has(fieldName)) continue;
            Class<?> objectType = f.getType();
            String currentPath = pathSoFar + (pathSoFar.equals("") ? "" : ".") + f.getName();
            if (PagedArray.class.isAssignableFrom(f.getType())) {
                JSONObject jsonPagingObject = object.optJSONObject(fieldName + ".pagination");
                JSONArray jsonArray = object.optJSONArray(fieldName);
                if (jsonPagingObject == null || jsonArray == null) continue;
                try {
                    long totalRecords = jsonPagingObject.getLong("totalRecords");
                    long limit = jsonPagingObject.getLong("limit");
                    long offset = jsonPagingObject.getLong("offset");
                    ParameterizedType genericTypeClazz = (ParameterizedType)f.getGenericType();
                    if (genericTypeClazz.getActualTypeArguments().length != 1) continue;
                    Class arrayObjectType = (Class)genericTypeClazz.getActualTypeArguments()[0];
                    ArrayList arrayObj = ContentDataDeserializer.deserializeArray(context, instanceId, arrayObjectType, jsonArray, currentPath);
                    Constructor<?> paginationConstructor = f.getType().getDeclaredConstructor(String.class, String.class, Class.class, Long.TYPE, Long.TYPE, Long.TYPE, ArrayList.class);
                    paginationConstructor.setAccessible(true);
                    PagedArray pagedArray = (PagedArray)paginationConstructor.newInstance(instanceId, currentPath, model, totalRecords, limit, offset, arrayObj);
                    f.set(contentDataObj, pagedArray);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (InvocationTargetException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (InstantiationException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.MALFORMED_JSON");
                }
            }
            if (object.optJSONArray(fieldName) != null) {
                Object paginationConstructor = null;
                try {
                    ArrayList objectArray = new ArrayList();
                    ParameterizedType genericTypeClazz = (ParameterizedType)f.getGenericType();
                    if (genericTypeClazz.getActualTypeArguments().length != 1) continue;
                    Class arrayObjectType = (Class)genericTypeClazz.getActualTypeArguments()[0];
                    ArrayList arrayObj = ContentDataDeserializer.deserializeArray(context, instanceId, arrayObjectType, object.optJSONArray(fieldName), currentPath);
                    if (List.class.isAssignableFrom(f.getType())) {
                        f.set(contentDataObj, arrayObj);
                        continue;
                    }
                    throw new FlybitsException("ContentDataDeserializer.deserializeArrayObject.NOT_PAGEDARRAY_OR_LIST");
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArrayObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArrayObject.CANNOT_INSTANTIATE_OBJ");
                }
            }
            if (LocalizedValue.class.isAssignableFrom(f.getType())) {
                JSONObject jsonLocalizationObject = object.optJSONObject("localizations");
                try {
                    if (jsonLocalizationObject == null) continue;
                    LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
                    Iterator keys = jsonLocalizationObject.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (jsonLocalizationObject.getJSONObject(key).isNull(fieldName)) continue;
                        values.put(key, jsonLocalizationObject.getJSONObject(key).getString(fieldName));
                    }
                    ArrayList languages = SharedElements.INSTANCE.getEnabledLanguagesAsArray();
                    String defaultLanguage = languages.size() > 0 && !((String)languages.get(0)).isEmpty() ? (String)languages.get(0) : "en";
                    LocalizedValue value = new LocalizedValue("en", defaultLanguage);
                    for (String key : ((HashMap)values).keySet()) {
                        value.addValue(key, (String)((HashMap)values).get(key));
                    }
                    f.set(contentDataObj, value);
                    continue;
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeLocalizationObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeLocalizationObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeLocalizationObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeLocalizationObject.MALFORMED_JSON");
                }
            }
            if (LocationData.class.isAssignableFrom(f.getType())) {
                JSONObject jsonLocationObject = object.optJSONObject(fieldName);
                try {
                    if (jsonLocationObject == null) continue;
                    double lat = 0.0;
                    double lng = 0.0;
                    double distance = -1.0;
                    String address = null;
                    LinkedHashMap values = new LinkedHashMap();
                    Iterator keys = jsonLocationObject.keys();
                    while (keys.hasNext()) {
                        JSONObject metadataObj;
                        String key = (String)keys.next();
                        if (key.equalsIgnoreCase("lat")) {
                            lat = jsonLocationObject.getDouble("lat");
                        }
                        if (key.equalsIgnoreCase("lng")) {
                            lng = jsonLocationObject.getDouble("lng");
                        }
                        if (!key.equalsIgnoreCase("metadata") || (metadataObj = jsonLocationObject.getJSONObject("metadata")).isNull("address")) continue;
                        address = metadataObj.getString("address");
                    }
                    if (!object.isNull("___" + fieldName + "_distance")) {
                        distance = object.getDouble("___" + fieldName + "_distance");
                    }
                    f.set(contentDataObj, new LocationData(lat, lng, distance, address));
                    continue;
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeLocalizationObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeLocalizationObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeLocalizationObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeLocalizationObject.MALFORMED_JSON");
                }
            }
            if (FieldHelper.checkIfPrimitiveType(f.getType())) {
                try {
                    Object jsonObject = object.get(fieldName);
                    Class<?> jsonType = jsonObject.getClass();
                    if (FieldHelper.isFloat(objectType) && jsonObject instanceof Double) {
                        f.set(contentDataObj, Float.valueOf(((Double)jsonObject).floatValue()));
                        continue;
                    }
                    if (FieldHelper.isDouble(objectType) && jsonObject instanceof Float) {
                        f.set(contentDataObj, ((Float)jsonObject).doubleValue());
                        continue;
                    }
                    if (FieldHelper.isInteger(objectType) && jsonObject instanceof Long) {
                        f.set(contentDataObj, ((Long)jsonObject).intValue());
                        continue;
                    }
                    if (FieldHelper.isLong(objectType) && jsonObject instanceof Integer) {
                        f.set(contentDataObj, ((Integer)jsonObject).longValue());
                        continue;
                    }
                    f.set(contentDataObj, jsonObject);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                    throw new FlybitsException(String.format(Locale.getDefault(), "ContentDataDeserializer.deserializeObject.JSON_POJO_DIFFER: Double check that the template and the POJO match! Field Name: %s", fieldName));
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_SET_PRIMITIVE");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeObject.MALFORMED_JSON");
                }
            }
            if (object.optJSONObject(fieldName) == null) continue;
            Constructor<?> objConstructor = null;
            try {
                objConstructor = f.getType().getDeclaredConstructor(new Class[0]);
                objConstructor.setAccessible(true);
                Object objInstantiated = objConstructor.newInstance(new Object[0]);
                ContentDataDeserializer.deserializeObject(context, instanceId, objInstantiated.getClass(), objInstantiated, object.getJSONObject(fieldName), currentPath);
                f.set(contentDataObj, objInstantiated);
            }
            catch (NoSuchMethodException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_INSTANTIATE_OBJ");
            }
            catch (InvocationTargetException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_INSTANTIATE_OBJ");
            }
            catch (IllegalAccessException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_INSTANTIATE_OBJ");
            }
            catch (InstantiationException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_INSTANTIATE_OBJ");
            }
            catch (JSONException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)((Object)e));
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.MALFORMED_JSON");
            }
        }
    }

    private static ArrayList deserializeArray(Context context, String instanceId, Class model, JSONArray array, String currentPath) throws FlybitsException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (FieldHelper.checkIfPrimitiveType(model)) {
            for (int i = 0; i < array.length(); ++i) {
                String arrayPath = currentPath + "[" + i + "]";
                try {
                    Object jsonObject = array.get(i);
                    Class<?> jsonType = jsonObject.getClass();
                    if (FieldHelper.isFloat(model) && jsonObject instanceof Double) {
                        list.add(Float.valueOf(((Double)jsonObject).floatValue()));
                        continue;
                    }
                    if (FieldHelper.isDouble(model) && jsonObject instanceof Float) {
                        list.add(((Float)jsonObject).doubleValue());
                        continue;
                    }
                    if (FieldHelper.isInteger(model) && jsonObject instanceof Long) {
                        list.add(((Long)jsonObject).intValue());
                        continue;
                    }
                    if (FieldHelper.isLong(model) && jsonObject instanceof Integer) {
                        list.add(((Integer)jsonObject).longValue());
                        continue;
                    }
                    list.add(jsonObject);
                    continue;
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeObject.MALFORMED_JSON");
                }
            }
        } else {
            for (int i = 0; i < array.length(); ++i) {
                String arrayPath = currentPath + "[" + i + "]";
                try {
                    JSONObject jsonObj = array.getJSONObject(i);
                    Constructor objConstructor = null;
                    objConstructor = model.getDeclaredConstructor(new Class[0]);
                    objConstructor.setAccessible(true);
                    Object objInstantiated = objConstructor.newInstance(new Object[0]);
                    ContentDataDeserializer.deserializeObject(context, instanceId, objInstantiated.getClass(), objInstantiated, jsonObj, arrayPath);
                    list.add(objInstantiated);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.CANNOT_INSTANTIATE_OBJ");
                }
                catch (InvocationTargetException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.CANNOT_INSTANTIATE_OBJ");
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.CANNOT_INSTANTIATE_OBJ");
                }
                catch (InstantiationException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.CANNOT_INSTANTIATE_OBJ");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.MALFORMED_JSON");
                }
            }
        }
        return list;
    }

    public static <T extends Parcelable> PagedArray<T> extractPagedArray(Object object, String fieldPath) throws FlybitsException {
        block7: {
            if (!fieldPath.contains(".")) {
                try {
                    Field f = FieldHelper.findField(fieldPath, object);
                    if (f != null && PagedArray.class.isAssignableFrom(f.getType())) {
                        f.setAccessible(true);
                        PagedArray array = (PagedArray)f.get(object);
                        return array;
                    }
                    break block7;
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new FlybitsException("Reflection Error");
                }
            }
            try {
                Field field = FieldHelper.findField(fieldPath.substring(0, fieldPath.indexOf(".")), object);
                field.setAccessible(true);
                if (!field.getType().isPrimitive() && !field.getType().isArray()) {
                    Object o = field.get(object);
                    return ContentDataDeserializer.extractPagedArray(o, fieldPath.substring(fieldPath.indexOf(".") + 1));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new FlybitsException("Reflection Error");
            }
        }
        return null;
    }
}

