package com.flybits.android.kernel.deserializers

/**
 * This annotation is currently only supported within classes being used to deserialize
 * or serialize {@link Content} instances.
 * It's purpose is to allow for customization of content field's.
 * Currently the only supported customization is field name.
 *
 * @property name the name of the field as represented in the content structure. You can use
 * this if the name of the variable within your class does not match the name of the field
 * in the content structure.
 */
@Target(AnnotationTarget.FIELD, AnnotationTarget.LOCAL_VARIABLE)
@Retention(AnnotationRetention.RUNTIME)
annotation class FlybitsData(val name: String)