/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db.dao;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.arch.persistence.room.util.StringUtil;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.db.converters.LocalizedValueConverters;
import com.flybits.android.kernel.db.dao.GroupDao;
import com.flybits.android.kernel.models.Group;
import com.flybits.android.kernel.models.LocalizedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GroupDao_Impl
implements GroupDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfGroup;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfGroup;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfGroup;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public GroupDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGroup = new EntityInsertionAdapter<Group>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `groups`(`id`,`creatorId`,`nameObject`,`descriptionObject`,`createdAt`,`modifiedAt`,`defaultLanguage`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Group value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCreatorId());
                }
                String _tmp = LocalizedValueConverters.localizedvalueToString(value.getNameObject());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = LocalizedValueConverters.localizedvalueToString(value.getDescriptionObject());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                stmt.bindLong(5, value.getCreatedAt());
                stmt.bindLong(6, value.getModifiedAt());
                if (value.getDefaultLanguage() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDefaultLanguage());
                }
            }
        };
        this.__deletionAdapterOfGroup = new EntityDeletionOrUpdateAdapter<Group>(__db){

            public String createQuery() {
                return "DELETE FROM `groups` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Group value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
            }
        };
        this.__updateAdapterOfGroup = new EntityDeletionOrUpdateAdapter<Group>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `groups` SET `id` = ?,`creatorId` = ?,`nameObject` = ?,`descriptionObject` = ?,`createdAt` = ?,`modifiedAt` = ?,`defaultLanguage` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Group value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getCreatorId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getCreatorId());
                }
                String _tmp = LocalizedValueConverters.localizedvalueToString(value.getNameObject());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = LocalizedValueConverters.localizedvalueToString(value.getDescriptionObject());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                stmt.bindLong(5, value.getCreatedAt());
                stmt.bindLong(6, value.getModifiedAt());
                if (value.getDefaultLanguage() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDefaultLanguage());
                }
                if (value.getId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getId());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM groups";
                return "DELETE FROM groups";
            }
        };
    }

    @Override
    public void insert(List<Group> groups) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGroup.insert(groups);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(Group groups) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGroup.insert((Object)groups);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(Group group) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfGroup.handle((Object)group);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Group group) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfGroup.handle((Object)group);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group getById(String id) {
        String _sql = "SELECT * FROM groups WHERE id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM groups WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            Group _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfCreatorId = _cursor.getColumnIndexOrThrow("creatorId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfDefaultLanguage = _cursor.getColumnIndexOrThrow("defaultLanguage");
            if (_cursor.moveToFirst()) {
                _result = new Group();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpCreatorId = _cursor.getString(_cursorIndexOfCreatorId);
                _result.setCreatorId(_tmpCreatorId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _result.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _result.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _result.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _result.setModifiedAt(_tmpModifiedAt);
                String _tmpDefaultLanguage = _cursor.getString(_cursorIndexOfDefaultLanguage);
                _result.setDefaultLanguage(_tmpDefaultLanguage);
            } else {
                _result = null;
            }
            Group group = _result;
            return group;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> getAll() {
        String _sql = "SELECT * FROM groups";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM groups", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfCreatorId = _cursor.getColumnIndexOrThrow("creatorId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfDefaultLanguage = _cursor.getColumnIndexOrThrow("defaultLanguage");
            ArrayList<Group> _result = new ArrayList<Group>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Group _item = new Group();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpCreatorId = _cursor.getString(_cursorIndexOfCreatorId);
                _item.setCreatorId(_tmpCreatorId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item.setModifiedAt(_tmpModifiedAt);
                String _tmpDefaultLanguage = _cursor.getString(_cursorIndexOfDefaultLanguage);
                _item.setDefaultLanguage(_tmpDefaultLanguage);
                _result.add(_item);
            }
            ArrayList<Group> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> getByCachedIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM groups WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfCreatorId = _cursor.getColumnIndexOrThrow("creatorId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfDefaultLanguage = _cursor.getColumnIndexOrThrow("defaultLanguage");
            ArrayList<Group> _result = new ArrayList<Group>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Group _item_1 = new Group();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpCreatorId = _cursor.getString(_cursorIndexOfCreatorId);
                _item_1.setCreatorId(_tmpCreatorId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item_1.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item_1.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item_1.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item_1.setModifiedAt(_tmpModifiedAt);
                String _tmpDefaultLanguage = _cursor.getString(_cursorIndexOfDefaultLanguage);
                _item_1.setDefaultLanguage(_tmpDefaultLanguage);
                _result.add(_item_1);
            }
            ArrayList<Group> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> getByCachedIds(List<String> ids, int limit) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM groups WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") LIMIT ");
        _stringBuilder.append("?");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, (long)limit);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfCreatorId = _cursor.getColumnIndexOrThrow("creatorId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfDefaultLanguage = _cursor.getColumnIndexOrThrow("defaultLanguage");
            ArrayList<Group> _result = new ArrayList<Group>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Group _item_1 = new Group();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpCreatorId = _cursor.getString(_cursorIndexOfCreatorId);
                _item_1.setCreatorId(_tmpCreatorId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item_1.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item_1.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item_1.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item_1.setModifiedAt(_tmpModifiedAt);
                String _tmpDefaultLanguage = _cursor.getString(_cursorIndexOfDefaultLanguage);
                _item_1.setDefaultLanguage(_tmpDefaultLanguage);
                _result.add(_item_1);
            }
            ArrayList<Group> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<Group> getByIdLive(String id) {
        String _sql = "SELECT * FROM groups WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM groups WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return new ComputableLiveData<Group>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Group compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("groups", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    GroupDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = GroupDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    Group _result;
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfCreatorId = _cursor.getColumnIndexOrThrow("creatorId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfDefaultLanguage = _cursor.getColumnIndexOrThrow("defaultLanguage");
                    if (_cursor.moveToFirst()) {
                        _result = new Group();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _result.setId(_tmpId);
                        String _tmpCreatorId = _cursor.getString(_cursorIndexOfCreatorId);
                        _result.setCreatorId(_tmpCreatorId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _result.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _result.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _result.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _result.setModifiedAt(_tmpModifiedAt);
                        String _tmpDefaultLanguage = _cursor.getString(_cursorIndexOfDefaultLanguage);
                        _result.setDefaultLanguage(_tmpDefaultLanguage);
                    } else {
                        _result = null;
                    }
                    Group group = _result;
                    return group;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Group>> getLive() {
        String _sql = "SELECT * FROM groups";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM groups", (int)0);
        return new ComputableLiveData<List<Group>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Group> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("groups", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    GroupDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = GroupDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfCreatorId = _cursor.getColumnIndexOrThrow("creatorId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfDefaultLanguage = _cursor.getColumnIndexOrThrow("defaultLanguage");
                    ArrayList<Group> _result = new ArrayList<Group>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Group _item = new Group();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpCreatorId = _cursor.getString(_cursorIndexOfCreatorId);
                        _item.setCreatorId(_tmpCreatorId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item.setModifiedAt(_tmpModifiedAt);
                        String _tmpDefaultLanguage = _cursor.getString(_cursorIndexOfDefaultLanguage);
                        _item.setDefaultLanguage(_tmpDefaultLanguage);
                        _result.add(_item);
                    }
                    ArrayList<Group> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    @Override
    public LiveData<List<Group>> getLiveByCacheIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM groups WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new ComputableLiveData<List<Group>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Group> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("groups", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    GroupDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = GroupDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfCreatorId = _cursor.getColumnIndexOrThrow("creatorId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfDefaultLanguage = _cursor.getColumnIndexOrThrow("defaultLanguage");
                    ArrayList<Group> _result = new ArrayList<Group>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Group _item_1 = new Group();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item_1.setId(_tmpId);
                        String _tmpCreatorId = _cursor.getString(_cursorIndexOfCreatorId);
                        _item_1.setCreatorId(_tmpCreatorId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item_1.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item_1.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item_1.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item_1.setModifiedAt(_tmpModifiedAt);
                        String _tmpDefaultLanguage = _cursor.getString(_cursorIndexOfDefaultLanguage);
                        _item_1.setDefaultLanguage(_tmpDefaultLanguage);
                        _result.add(_item_1);
                    }
                    ArrayList<Group> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM groups WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

