package com.flybits.android.kernel.deserializers;

import android.content.Context;

import com.flybits.android.kernel.models.internal.ContentDataResponse;
import com.flybits.android.kernel.utilities.ContentDataDeserializer;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Pagination;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class DeserializeContentDatum<T> extends IDeserializer<ContentDataResponse<T>>{

    private Context context;
    private String instanceId;
    private Class modelClass;

    public DeserializeContentDatum(Context context, String instanceId, Class modelClass){
        this.context        = context;
        this.instanceId     = instanceId;
        this.modelClass     = modelClass;
    }

    @Override
    public String toJson(ContentDataResponse<T> contentData) {
        JSONObject object = new JSONObject();
        return object.toString();
    }

    @Override
    public ContentDataResponse<T> fromJson(String json) {

        try {
            ArrayList<T> listOfData = null;
            Pagination pagination                       = null;
            JSONObject jObj = new JSONObject(json);
            if (!jObj.isNull("data") && !jObj.isNull("pagination")) {
                listOfData     = new ArrayList<>();

                JSONObject jsonPagination   = jObj.getJSONObject("pagination");
                if (!jsonPagination.isNull("limit") && !jsonPagination.isNull("totalRecords")
                        && !jsonPagination.isNull("offset")){
                    int limit        = jsonPagination.getInt("limit");
                    int offset       = jsonPagination.getInt("offset");
                    int totalRecords = jsonPagination.getInt("totalRecords");
                    pagination              = new Pagination(limit, offset, totalRecords);
                }else{
                    return null;
                }

                JSONArray datasArray         = jObj.getJSONArray("data");

                for (int i = 0; i < datasArray.length(); i++) {
                    String dataJson = datasArray.getJSONObject(i).toString();
                    T data = ContentDataDeserializer.deserialize(context, instanceId, modelClass, dataJson);
                    listOfData.add(data);
                }
                return new ContentDataResponse<>(listOfData, instanceId, pagination);
            }
        }catch (JSONException | FlybitsException e){
            Logger.exception("DeserializeContentDatum.fromJson", e);
        }
        return null;
    }

    @Override
    public ContentDataResponse<T> fromJson(JSONObject jsonObject) {
        return null;
    }

    @Override
    public ContentDataResponse<T> fromJson(JSONArray jsonArray) {
        return null;
    }

}
