/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.workers;

import android.content.Context;
import android.support.annotation.NonNull;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.Preference;
import com.flybits.internal.models.preferences.FlybitsFavourite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FavouritesSyncWorker
extends Worker {
    public FavouritesSyncWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        FlybitsFavourite favourites = new FlybitsFavourite(this.getApplicationContext());
        favourites.getFromServer("ContentFavourite", (ObjectResultCallback)new ObjectResultCallback<ArrayList<String>>(){

            public void onSuccess(final ArrayList<String> items) {
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<Preference> listOfFlybitsPreferences = new ArrayList<Preference>();
                        try {
                            HashSet set;
                            if (items != null && (set = new HashSet(items)).size() > 0) {
                                items.clear();
                                items.addAll(set);
                                for (String item : items) {
                                    listOfFlybitsPreferences.add(new Preference("ContentFavourite", item));
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        CommonsDatabase.getDatabase((Context)FavouritesSyncWorker.this.getApplicationContext()).preferenceDAO().deleteByPrefKey("ContentFavourite");
                        if (listOfFlybitsPreferences.size() > 0) {
                            CommonsDatabase.getDatabase((Context)FavouritesSyncWorker.this.getApplicationContext()).preferenceDAO().insert(listOfFlybitsPreferences);
                        }
                        countDownLatch.countDown();
                    }
                });
            }

            public void onException(FlybitsException exception) {
            }
        });
        try {
            if (!countDownLatch.await(5L, TimeUnit.SECONDS)) {
                return ListenableWorker.Result.RETRY;
            }
        }
        catch (InterruptedException e) {
            return ListenableWorker.Result.RETRY;
        }
        return ListenableWorker.Result.SUCCESS;
    }
}

