package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.PagedArray;

/**
 * This POJO stores the compiled results of the surveys, when requested from the SurveyResults content
 * instance.
 */

public class SurveyResult implements Parcelable{

    public PagedArray<Result> results;
    public String surveyId;
    public Long totalVotes;

    public SurveyResult(){}

    protected SurveyResult(Parcel in) {
        totalVotes = in.readLong();
        surveyId = in.readString();
        results = in.readParcelable(PagedArray.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(totalVotes);
        dest.writeString(surveyId);
        dest.writeParcelable(results, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Parcelable.Creator<SurveyResult> CREATOR = new Parcelable.Creator<SurveyResult>() {
        @Override
        public SurveyResult createFromParcel(Parcel in) {
            return new SurveyResult(in);
        }

        @Override
        public SurveyResult[] newArray(int size) {
            return new SurveyResult[size];
        }
    };

}
