/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.deserializers;

import android.content.Context;
import com.flybits.android.kernel.models.Experience;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.deserializations.IDeserializer;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeExperience
extends IDeserializer<Experience> {
    private Context context;

    public DeserializeExperience(Context context) {
        this.context = context;
    }

    public String toJson(Experience experience) {
        JSONObject objectLanguageCode2;
        JSONObject object = new JSONObject();
        try {
            object.put("creatorId", (Object)experience.getCreatorID());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            object.put("defaultLanguage", (Object)"en");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JSONObject localizationObject = new JSONObject();
        ArrayList<String> listofCodes = new ArrayList<String>();
        for (String code : experience.getNameObject().getListOfSupportedLanguages()) {
            try {
                if (experience.getName(code) == null) continue;
                listofCodes.add(code);
                objectLanguageCode2 = new JSONObject();
                objectLanguageCode2.put("name", (Object)experience.getName(code));
                localizationObject.put(code, (Object)objectLanguageCode2);
                if (experience.getDescription(code) == null) continue;
                objectLanguageCode2.put("description", (Object)experience.getDescription(code));
                localizationObject.put(code, (Object)objectLanguageCode2);
            }
            catch (JSONException objectLanguageCode2) {}
        }
        for (String code : experience.getDescriptionObject().getListOfSupportedLanguages()) {
            try {
                if (listofCodes.contains(code) || experience.getDescription(code) == null) continue;
                objectLanguageCode2 = new JSONObject();
                objectLanguageCode2.put("description", (Object)experience.getDescription(code));
                localizationObject.put(code, (Object)objectLanguageCode2);
            }
            catch (JSONException jSONException) {}
        }
        try {
            object.put("localizations", (Object)localizationObject);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            object.put("isActive", experience.isActive());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }

    public Experience fromJson(JSONObject jsonObject) {
        try {
            if (!(jsonObject.isNull("id") || jsonObject.isNull("creatorId") || jsonObject.isNull("isActive"))) {
                String id = jsonObject.getString("id");
                String creatorId = jsonObject.getString("creatorId");
                boolean isActive = jsonObject.getBoolean("isActive");
                ArrayList<String> labels = new ArrayList<String>();
                long createdAt = -1L;
                long modifiedAt = -1L;
                if (!jsonObject.isNull("createdAt")) {
                    createdAt = jsonObject.getLong("createdAt");
                }
                if (!jsonObject.isNull("modifiedAt")) {
                    modifiedAt = jsonObject.getLong("modifiedAt");
                }
                if (!jsonObject.isNull("labels")) {
                    JSONArray jsonArray = jsonObject.getJSONArray("labels");
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        labels.add(jsonArray.getString(i));
                    }
                }
                Experience experience = new Experience(id, creatorId, "en", isActive, createdAt, modifiedAt, SharedElements.INSTANCE.getEnabledLanguagesAsString(this.context), labels);
                if (!jsonObject.isNull("localizations")) {
                    JSONObject localizationObject = jsonObject.getJSONObject("localizations");
                    Iterator languages = localizationObject.keys();
                    while (languages.hasNext()) {
                        String language = (String)languages.next();
                        JSONObject languageObj = localizationObject.getJSONObject(language);
                        if (!languageObj.isNull("description")) {
                            experience.setDescription(language, languageObj.getString("description"));
                        }
                        if (languageObj.isNull("name")) continue;
                        experience.setName(language, languageObj.getString("name"));
                    }
                }
                return experience;
            }
            return null;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Experience fromJson(JSONArray jsonArray) {
        return null;
    }
}

