package com.flybits.android.kernel.workers

import android.content.Context
import androidx.work.Worker
import androidx.work.WorkerParameters
import com.flybits.android.kernel.models.Content
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.internal.db.CommonsDatabase
import com.flybits.internal.db.models.Preference
import com.flybits.internal.models.preferences.FlybitsFavourite
import kotlinx.coroutines.*
import java.util.ArrayList
import java.util.concurrent.CountDownLatch
import java.util.concurrent.TimeUnit

/**
 * A Worker class that syncs favourites to local database from server
 *
 * @param context The [Context] of the application.
 * @param params Any params that define how the worker behaves
 *
 */

class FavouritesSyncWorker(context: Context, params: WorkerParameters) : Worker(context, params) {

    internal var flybitsFavourite: FlybitsFavourite = FlybitsFavourite(context)

    override fun doWork(): Result {
        var result = Result.failure()
        val countDownLatch = CountDownLatch(1)
        var job : Job? = null

        flybitsFavourite.getFromServer(Content.FAVOURITE_KEY, object :
            ObjectResultCallback<ArrayList<String>> {


            override fun onSuccess(items: ArrayList<String>) {

                job = CoroutineScope(Dispatchers.IO).launch {

                    val list = items.distinct().map {
                        Preference(
                            Content.FAVOURITE_KEY,
                            it
                        )
                    }

                    CommonsDatabase.getDatabase(applicationContext)
                        .preferenceDAO()
                        .deleteByPrefKey(Content.FAVOURITE_KEY)

                    CommonsDatabase.getDatabase(applicationContext)
                        .preferenceDAO()
                        .insert(list)

                    result =  Result.success()
                    countDownLatch.countDown()
                }
            }

            override fun onException(exception: FlybitsException) {
                job = CoroutineScope(Dispatchers.Default).launch {
                    result =  Result.failure()
                    countDownLatch.countDown()
                    return@launch
                }
            }
        })

        return try {
            if(!countDownLatch.await(5, TimeUnit.SECONDS)) {
                job?.cancel()
                Result.failure()
            } else {
                result
            }
        } catch ( e : InterruptedException){
            Result.retry()
        } catch (e : java.lang.Exception){
            Result.failure()
        }
    }
}