/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import com.flybits.android.kernel.deserializers.ContentId;
import com.flybits.android.kernel.deserializers.FlybitsData;
import com.flybits.android.kernel.deserializers.Ignore;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0007J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0007J\u0014\u0010\u0011\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0007J\u0014\u0010\u0013\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007J\u0014\u0010\u0014\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0007J\u0014\u0010\u0016\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007J\u0014\u0010\u0017\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007J\u0014\u0010\u0018\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0007\u00a8\u0006\u0019"}, d2={"Lcom/flybits/android/kernel/utilities/FieldHelper;", "", "()V", "checkIfPrimitiveType", "", "type", "Ljava/lang/Class;", "findField", "Ljava/lang/reflect/Field;", "name", "", "object", "getAllFields", "", "model", "getFieldName", "f", "isBoolean", "isContentIdField", "isDouble", "isFloat", "isIgnored", "isInteger", "isLong", "isString", "kernel_release"})
public final class FieldHelper {
    public static final FieldHelper INSTANCE;

    @JvmStatic
    @NotNull
    public static final Set<Field> getAllFields(@NotNull Class<?> model) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        boolean bl = false;
        Set fieldList = new LinkedHashSet();
        Class<?> superClass = model.getSuperclass();
        if (superClass != null && Intrinsics.areEqual(superClass, Object.class) ^ true) {
            fieldList.addAll((Collection)FieldHelper.getAllFields(superClass));
        }
        Collection collection = fieldList;
        Object[] objectArray = model.getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"model.declaredFields");
        CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
        return fieldList;
    }

    @JvmStatic
    @NotNull
    public static final Field findField(@NotNull String name, @NotNull Object object) throws NoSuchFieldException {
        Field field;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        Field annotatedField = null;
        Field nativeField = null;
        Object[] objectArray = object.getClass().getDeclaredFields();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Field f;
            Field field2 = f = objectArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"f");
            field2.setAccessible(true);
            FlybitsData a = f.getAnnotation(FlybitsData.class);
            if (a != null && Intrinsics.areEqual((Object)a.name(), (Object)name)) {
                annotatedField = f;
                break;
            }
            if (!Intrinsics.areEqual((Object)f.getName(), (Object)name)) continue;
            nativeField = f;
        }
        if ((field = annotatedField) == null && (field = nativeField) == null) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "No field matching name: %s found.";
            objectArray = new Object[]{name};
            n = 0;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string = string3;
            throw (Throwable)new NoSuchFieldException(string4);
        }
        return field;
    }

    @JvmStatic
    public static final boolean isContentIdField(@NotNull Field f) {
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        return f.getAnnotation(ContentId.class) != null;
    }

    @JvmStatic
    public static final boolean isIgnored(@NotNull Field f) {
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        return f.getAnnotation(Ignore.class) != null;
    }

    @JvmStatic
    @NotNull
    public static final String getFieldName(@NotNull Field f) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        FlybitsData annotation = f.getAnnotation(FlybitsData.class);
        if (annotation == null) {
            String string2 = f.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"f.name");
        } else {
            string = annotation.name();
        }
        return string;
    }

    @JvmStatic
    public static final boolean checkIfPrimitiveType(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return FieldHelper.isString(type) || FieldHelper.isBoolean(type) || FieldHelper.isFloat(type) || FieldHelper.isDouble(type) || FieldHelper.isInteger(type) || FieldHelper.isLong(type);
    }

    @JvmStatic
    public static final boolean isString(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return Intrinsics.areEqual((Object)type.getName(), (Object)"java.lang.String");
    }

    @JvmStatic
    public static final boolean isBoolean(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return Intrinsics.areEqual((Object)type.getName(), (Object)"java.lang.Boolean") || Intrinsics.areEqual((Object)type.getName(), (Object)"boolean");
    }

    @JvmStatic
    public static final boolean isFloat(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return Intrinsics.areEqual((Object)type.getName(), (Object)"java.lang.Float") || Intrinsics.areEqual((Object)type.getName(), (Object)"float");
    }

    @JvmStatic
    public static final boolean isDouble(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return Intrinsics.areEqual((Object)type.getName(), (Object)"java.lang.Double") || Intrinsics.areEqual((Object)type.getName(), (Object)"double");
    }

    @JvmStatic
    public static final boolean isInteger(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return Intrinsics.areEqual((Object)type.getName(), (Object)"java.lang.Integer") || Intrinsics.areEqual((Object)type.getName(), (Object)"int");
    }

    @JvmStatic
    public static final boolean isLong(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return Intrinsics.areEqual((Object)type.getName(), (Object)"java.lang.Long") || Intrinsics.areEqual((Object)type.getName(), (Object)"long");
    }

    private FieldHelper() {
    }

    static {
        FieldHelper fieldHelper;
        INSTANCE = fieldHelper = new FieldHelper();
    }
}

