package com.flybits.android.kernel.models.results;

import android.content.Context;
import android.os.Handler;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.utilities.ContentParameters;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.ExecutorService;

public class ContentResult extends PagedResult<Content> {

    public ContentResult(Context context, QueryParameters params, PagedResultCallback<Content> callback, ExecutorService service, Handler handler){
        super(context, params, callback, handler, service);
    }

    @Override
    public <K extends QueryParameters> void getMoreRequest(@NotNull K k, @NotNull PagedResultCallback<Content> pagedResultCallback) {
        Content.get(getContext(), (ContentParameters) k, pagedResultCallback);
    }
}
