package com.flybits.android.kernel.utilities;

import android.support.annotation.NonNull;

import com.flybits.android.kernel.models.Group;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;

import java.util.ArrayList;
import java.util.Map;

/**
 * The {@link GroupParameters} class is used to define all the parameters set for the GET
 * request associated to {@link Group}.
 */
public class GroupParameters extends QueryParameters {

    private GroupParameters(GroupParameters.Builder builder) {
        super(builder);
    }

    /**
     * Get the list of query parameters that should be added to the GET request.
     *
     * @return A list of parameters that should be added to the GET query.
     */
    public Map<String, ArrayList<String>> getQueryParams(){

        Map<String, ArrayList<String>> params = super.getQueryParams();
        return params;
    }

    /**
     * {@code Builder} class used the create an {@link GroupParameters} class, which defines
     * all parameters used within the GET request for
     * {@link Group}.
     */
    public static class Builder extends QueryBuilder<Builder>{

        /**
         * Default constructor to initializes all variables.
         */
        public Builder(){
            super();
        }

        /**
         * Sets the caching key for the query. This is useful because it allows you to later retrieve
         * cached copies of the query that you just made.
         *
         * @param cachingKey A unique key that represents the query. If no {@code cachingKey} is set a
         *                   hash of the query parameters will be used.
         * @param limit The maximum number of entities that can be cached.
         * @return The {@link ContentParameters.Builder} that can be used to add other Content parameters for.
         */
        public Builder setCaching(@NonNull String cachingKey, int limit){
            super.setCaching(cachingKey, limit);
            return this;
        }

        /**
         * Create a {@link GroupParameters} object that contains all parameters associated to
         * the GET request for {@link Group}.
         *
         * @return {@link GroupParameters} which is used to create a valid
         * {@link Group} GET request.
         */
        public GroupParameters build(){
            return new GroupParameters(this);
        }
    }
}
