package com.flybits.android.kernel.workers;

import android.content.Context;
import android.support.annotation.NonNull;

import androidx.work.Worker;
import androidx.work.WorkerParameters;

import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.Preference;
import com.flybits.internal.models.preferences.FlybitsFavourite;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FavouritesSyncWorker extends Worker {

    protected FlybitsFavourite flybitsFavourite;

    public FavouritesSyncWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
        flybitsFavourite = new FlybitsFavourite(getApplicationContext());
    }

    @NonNull
    @Override
    public Result doWork() {

        final ArrayList<Preference> listOfFlybitsPreferences = new ArrayList<>();

        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        final CountDownLatch countDownLatch = new CountDownLatch(1);

        flybitsFavourite.getFromServer(Content.FAVOURITE_KEY, new ObjectResultCallback<ArrayList<String>>() {
            @Override
            public void onSuccess(final ArrayList<String> items) {

                executorService.execute(new Runnable() {
                    @Override
                    public void run() {

                        try {
                            if (items != null) {

                                //Set is used to remove any duplicates ... there are nicer ways to do this once we go to 1.8
                                Set<String> set = new HashSet<>(items);
                                if (set.size() > 0) {

                                    ArrayList<String> itemsToSave = new ArrayList<>(set);
                                    for (String item : itemsToSave) {
                                        listOfFlybitsPreferences.add(new Preference(Content.FAVOURITE_KEY, item));
                                    }
                                }
                            }
                        } catch (Exception e) {
                            return ;
                        }

                        CommonsDatabase.getDatabase(getApplicationContext()).preferenceDAO().deleteByPrefKey(Content.FAVOURITE_KEY);
                        if (listOfFlybitsPreferences.size() > 0) {
                            CommonsDatabase.getDatabase(getApplicationContext()).preferenceDAO().insert(listOfFlybitsPreferences);
                        }
                        countDownLatch.countDown();
                    }
                });
            }

            @Override
            public void onException(FlybitsException exception) { }
        });


        try {
            if (!countDownLatch.await(5, TimeUnit.SECONDS)) {
                return Result.failure();
            }
        } catch (InterruptedException e) {
            return Result.retry();
        }

        return Result.success();
    }
}
