/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.workers.FavouritesSyncWorker;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.models.User;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\nJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/flybits/android/kernel/KernelScope;", "Lcom/flybits/commons/library/api/FlybitsScope;", "()V", "cancelWorkers", "", "clearDatabase", "context", "Landroid/content/Context;", "clearDatabase$kernel_release", "clearDatabaseAsync", "clearDatabaseAsync$kernel_release", "onAccountDestroyed", "s", "", "onConnected", "user", "Lcom/flybits/commons/library/models/User;", "onDisconnected", "onOptedStateChange", "optedState", "", "scheduleWorkers", "Companion", "kernel_release"})
public final class KernelScope
extends FlybitsScope {
    @NotNull
    public static final String WORKER_NAME_CONTENT_FAVS = "Get_Content_Favs";
    @NotNull
    public static final String ROOT = "/kernel";
    @NotNull
    private static final KernelScope SCOPE;
    public static final Companion Companion;

    public void onConnected(@NotNull Context context, @NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.scheduleWorkers();
    }

    public void onDisconnected(@NotNull Context context, @NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.cancelWorkers();
        this.clearDatabaseAsync$kernel_release(context);
    }

    public void onAccountDestroyed(@NotNull Context context, @NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.clearDatabaseAsync$kernel_release(context);
    }

    public void onOptedStateChange(@NotNull Context context, boolean optedState) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!optedState) {
            this.clearDatabaseAsync$kernel_release(context);
            this.cancelWorkers();
        } else {
            this.scheduleWorkers();
        }
    }

    public final void clearDatabaseAsync$kernel_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Executors.newSingleThreadExecutor().execute(new Runnable(this, context){
            final /* synthetic */ KernelScope this$0;
            final /* synthetic */ Context $context;

            public final void run() {
                this.this$0.clearDatabase$kernel_release(this.$context);
            }
            {
                this.this$0 = kernelScope;
                this.$context = context;
            }
        });
    }

    private final void scheduleWorkers() {
        WorkRequest workRequest = ((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(FavouritesSyncWorker.class, 1L, TimeUnit.DAYS).addTag(WORKER_NAME_CONTENT_FAVS)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"PeriodicWorkRequest.Buil\u2026\n                .build()");
        PeriodicWorkRequest taskGetPluginsRepeat = (PeriodicWorkRequest)workRequest;
        WorkManager.getInstance().enqueueUniquePeriodicWork(WORKER_NAME_CONTENT_FAVS, ExistingPeriodicWorkPolicy.REPLACE, taskGetPluginsRepeat);
    }

    private final void cancelWorkers() {
        WorkManager.getInstance().cancelUniqueWork(WORKER_NAME_CONTENT_FAVS);
    }

    public final void clearDatabase$kernel_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KernelDatabase db = KernelDatabase.getDatabase(context);
        db.contentDao().clear();
        db.groupDao().clear();
    }

    private KernelScope() {
        super("Kernel");
    }

    static {
        Companion = new Companion(null);
        SCOPE = new KernelScope();
    }

    @NotNull
    public static final KernelScope getSCOPE() {
        Companion companion = Companion;
        return SCOPE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/flybits/android/kernel/KernelScope$Companion;", "", "()V", "ROOT", "", "SCOPE", "Lcom/flybits/android/kernel/KernelScope;", "SCOPE$annotations", "getSCOPE", "()Lcom/flybits/android/kernel/KernelScope;", "WORKER_NAME_CONTENT_FAVS", "getKernelPreferences", "Landroid/content/SharedPreferences;", "context", "Landroid/content/Context;", "kernel_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void SCOPE$annotations() {
        }

        @NotNull
        public final KernelScope getSCOPE() {
            return SCOPE;
        }

        @NotNull
        public final SharedPreferences getKernelPreferences(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            SharedPreferences sharedPreferences = context.getSharedPreferences("FLYBITS_PREF_KERNEL", 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026EF_KERNEL\", MODE_PRIVATE)");
            return sharedPreferences;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

