package com.flybits.android.kernel.utilities

import com.flybits.android.kernel.deserializers.ContentId
import com.flybits.android.kernel.deserializers.FlybitsData
import com.flybits.android.kernel.deserializers.Ignore
import java.lang.reflect.Field

object FieldHelper {

    @JvmStatic
    fun getAllFields(model: Class<*>): Set<Field> {
        val fieldList = mutableSetOf<Field>()
        val superClass = model.superclass
        if (superClass != null && superClass != Object::class.java) {
            fieldList.addAll(getAllFields(superClass))
        }
        fieldList.addAll(model.declaredFields)
        return fieldList
    }

    //Private fields will return as accessible
    @Throws(NoSuchFieldException::class)
    @JvmStatic
    fun findField(name: String, `object`: Any): Field {
        var annotatedField: Field? = null
        var nativeField: Field? = null

        //Look for annotation or field matching pontential name, prioritizing annotation
        for (f in `object`.javaClass.declaredFields) {
            f.isAccessible = true
            val a = f.getAnnotation(FlybitsData::class.java)
            if (a != null && (a as FlybitsData).name == name) {
                annotatedField = f
                break
            } else if (f.name == name) {
                nativeField = f
            }
        }

        return annotatedField ?: (nativeField
                ?: throw NoSuchFieldException(String.format("No field matching name: %s found.", name)))
    }

    @JvmStatic
    fun isContentIdField(f: Field) = f.getAnnotation(ContentId::class.java) != null

    @JvmStatic
    fun isIgnored(f: Field) = f.getAnnotation(Ignore::class.java) != null

    @JvmStatic
    fun getFieldName(f: Field): String {
        val annotation = f.getAnnotation(FlybitsData::class.java)
        return if (annotation == null) f.name else (annotation as FlybitsData).name
    }

    @JvmStatic
    fun checkIfPrimitiveType(type: Class<*>) = isString(type) || isBoolean(type) || isFloat(type) || isDouble(type) || isInteger(type) || isLong(type)

    @JvmStatic
    fun isString(type: Class<*>) = type.name == "java.lang.String"

    @JvmStatic
    fun isBoolean(type: Class<*>) = type.name == "java.lang.Boolean" || type.name == "boolean"

    @JvmStatic
    fun isFloat(type: Class<*>) = type.name == "java.lang.Float" || type.name == "float"

    @JvmStatic
    fun isDouble(type: Class<*>) = type.name == "java.lang.Double" || type.name == "double"

    @JvmStatic
    fun isInteger(type: Class<*>) = type.name == "java.lang.Integer" || type.name == "int"

    @JvmStatic
    fun isLong(type: Class<*>) = type.name == "java.lang.Long" || type.name == "long"
}
