/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import android.support.annotation.NonNull;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import java.util.ArrayList;
import java.util.Map;

public class ContentParameters
extends QueryParameters {
    private String locId;
    private double latitude;
    private double longitude;
    private double radius;
    private String url;
    private String templateId;
    private String templateType;

    private ContentParameters(Builder builder) {
        super((QueryBuilder)builder);
        this.templateId = builder.templateId;
        this.templateType = builder.templateType;
        this.locId = builder.locId;
        if (this.locId != null) {
            this.latitude = builder.latitude;
            this.longitude = builder.longitude;
            this.radius = builder.radius;
            if (builder.templateId != null) {
                this.templateId = builder.templateId;
            }
        }
        this.url = this.locId != null || this.templateId != null ? "/kernel/content/instances" : "/kernel/experiences/contents";
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        Map params = super.getQueryParams();
        if (this.locId != null) {
            ArrayList<String> latitudeParam = new ArrayList<String>();
            latitudeParam.add(String.valueOf(this.latitude));
            params.put("lat", latitudeParam);
            ArrayList<String> longitudeParam = new ArrayList<String>();
            longitudeParam.add(String.valueOf(this.longitude));
            params.put("lng", longitudeParam);
            ArrayList<String> radiusParam = new ArrayList<String>();
            radiusParam.add(String.valueOf(this.radius));
            params.put("radius", radiusParam);
            ArrayList<String> locParam = new ArrayList<String>();
            locParam.add(String.valueOf(this.locId));
            params.put("loc", locParam);
        }
        if (this.templateId != null) {
            ArrayList<String> templateIdParam = new ArrayList<String>();
            templateIdParam.add(String.valueOf(this.templateId));
            params.put("templateId", templateIdParam);
        }
        if (this.templateType != null) {
            ArrayList<String> templateTypeParam = new ArrayList<String>();
            templateTypeParam.add(String.valueOf(this.templateType));
            params.put("templatetype", templateTypeParam);
        }
        ArrayList<String> dataParam = new ArrayList<String>();
        dataParam.add(String.valueOf(true));
        params.put("data", dataParam);
        return params;
    }

    public String getUrl() {
        return this.url;
    }

    public static class Builder
    extends QueryBuilder<Builder> {
        private String locId;
        private double latitude;
        private double longitude;
        private double radius;
        private String templateId;
        private String templateType;

        public Builder setCaching(@NonNull String cachingKey, int limit) {
            super.setCaching(cachingKey, limit);
            return this;
        }

        public Builder setLocation(@NonNull String loc, double latitude, double longitude, long radius) {
            return this.setLocation(loc, latitude, longitude, radius, null);
        }

        public Builder setLocation(@NonNull String loc, double latitude, double longitude, long radius, String templateId) {
            this.locId = loc;
            this.latitude = latitude;
            this.longitude = longitude;
            this.radius = radius;
            this.templateId = templateId;
            return this;
        }

        public Builder setTemplateId(@NonNull String id) {
            this.templateId = id;
            return this;
        }

        public Builder setTemplateType(@NonNull String type) {
            this.templateType = type;
            return this;
        }

        public ContentParameters build() {
            return new ContentParameters(this);
        }
    }
}

