/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db.dao;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Transaction;
import com.flybits.android.kernel.models.Content;
import java.util.List;

@Dao
public abstract class ContentDao {
    @Query(value="SELECT * FROM content WHERE id = :id")
    public abstract Content getById(String var1);

    @Query(value="SELECT * FROM content")
    public abstract List<Content> getAll();

    @Query(value="SELECT * FROM content WHERE id IN (:ids)")
    public abstract List<Content> getByCachedIds(List<String> var1);

    @Query(value="SELECT * FROM content WHERE id IN (:ids) LIMIT :limit")
    public abstract List<Content> getByCachedIds(List<String> var1, int var2);

    @Query(value="SELECT * FROM content WHERE templateId = :templateId")
    public abstract List<Content> getAllByTemplateId(String var1);

    @Insert(onConflict=1)
    public abstract void insert(List<Content> var1);

    @Query(value="DELETE FROM content")
    public abstract void clear();

    @Query(value="DELETE FROM content WHERE id IN (:ids)")
    public abstract void deleteByIds(List<String> var1);

    @Query(value="SELECT * FROM content")
    public abstract LiveData<List<Content>> getLive();

    @Query(value="SELECT * FROM content WHERE id IN (:ids)")
    public abstract LiveData<List<Content>> getLiveByCacheIds(List<String> var1);

    @Query(value="SELECT * FROM content WHERE id = :id")
    public abstract LiveData<List<Content>> getLiveById(String var1);

    @Query(value="SELECT * FROM content WHERE templateId = :templateId")
    public abstract LiveData<List<Content>> getLiveAllByTemplateId(String var1);

    @Transaction
    public void insertAndDeleteInTransaction(List<String> deleteContentIds, List<Content> insertContent) {
        this.deleteByIds(deleteContentIds);
        this.insert(insertContent);
    }
}

