/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.workers;

import android.content.Context;
import android.support.annotation.NonNull;
import androidx.work.Worker;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.Preference;
import com.flybits.internal.models.preferences.FlybitsFavourite;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FavouritesSyncWorker
extends Worker {
    public static final String FLYBITS_PREF_FAVS_TIMESTAMP = "favsRefreshTime";

    @NonNull
    public Worker.Result doWork() {
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        FlybitsFavourite favourites = new FlybitsFavourite(this.getApplicationContext());
        favourites.getFromServer("ContentFavourite", (ObjectResultCallback)new ObjectResultCallback<ArrayList<String>>(){

            public void onSuccess(final ArrayList<String> items) {
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<Preference> listOfFlybitsPreferences = new ArrayList<Preference>();
                        for (String item : items) {
                            listOfFlybitsPreferences.add(new Preference("ContentFavourite", item));
                        }
                        CommonsDatabase.getDatabase((Context)FavouritesSyncWorker.this.getApplicationContext()).preferenceDAO().deleteByPrefKey(FavouritesSyncWorker.FLYBITS_PREF_FAVS_TIMESTAMP);
                        CommonsDatabase.getDatabase((Context)FavouritesSyncWorker.this.getApplicationContext()).preferenceDAO().insert(listOfFlybitsPreferences);
                        countDownLatch.countDown();
                    }
                });
            }

            public void onException(FlybitsException exception) {
            }
        });
        try {
            if (!countDownLatch.await(5L, TimeUnit.SECONDS)) {
                return Worker.Result.RETRY;
            }
        }
        catch (InterruptedException e) {
            return Worker.Result.RETRY;
        }
        return Worker.Result.SUCCESS;
    }
}

