package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.PagedArray;

/**
 * This POJO stores the Survey questions when requested from the SurveyQuestions content instance.
 */

public class SurveyQuestion implements Parcelable{

    public String _id;
    public String resultId;
    public PagedArray<Question> questions;

    public SurveyQuestion(){}

    protected SurveyQuestion(Parcel in) {
        _id = in.readString();
        resultId = in.readString();
        questions = in.readParcelable(PagedArray.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(_id);
        dest.writeString(resultId);
        dest.writeParcelable(questions, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<SurveyQuestion> CREATOR = new Creator<SurveyQuestion>() {
        @Override
        public SurveyQuestion createFromParcel(Parcel in) {
            return new SurveyQuestion(in);
        }

        @Override
        public SurveyQuestion[] newArray(int size) {
            return new SurveyQuestion[size];
        }
    };
}
