package com.flybits.android.kernel.db.dao;

import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;

import com.flybits.android.kernel.models.Experience;

import java.util.List;

import static android.arch.persistence.room.OnConflictStrategy.REPLACE;

public interface ExperienceDao {

    @Query("SELECT * FROM experiences")
    List<Experience> getAll();

    @Query("SELECT * FROM experiences WHERE id = :id")
    Experience getById(String id);

    @Insert(onConflict = REPLACE)
    void insertOrReplaceNewExperience(List<Experience> experiences);

    @Query("DELETE FROM experiences")
    void clear();
}
