/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentDataDeserializer {
    public static <T> T deserialize(String instanceId, @NonNull Class model, String json) throws FlybitsException {
        Constructor contentDataConstructor = null;
        try {
            contentDataConstructor = model.getDeclaredConstructor(new Class[0]);
            contentDataConstructor.setAccessible(true);
            Object contentDataObj = contentDataConstructor.newInstance(new Object[0]);
            JSONObject object = new JSONObject(json);
            ContentDataDeserializer.deserializeObject(instanceId, model, contentDataObj, object, "");
            return contentDataObj;
        }
        catch (NoSuchMethodException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (InvocationTargetException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (IllegalAccessException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (InstantiationException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (NullPointerException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)e);
            throw new FlybitsException("ContentDataDeserializer.CANNOT_INSTANTIATE_OBJ");
        }
        catch (JSONException e) {
            Logger.exception((String)"ContentDataDeserializer.deserialize", (Exception)((Object)e));
            throw new FlybitsException("ContentDataDeserializer.MALFORMED_JSON");
        }
    }

    static <T> void deserializeObject(String instanceId, Class model, T contentDataObj, JSONObject object, String pathSoFar) throws FlybitsException {
        for (Field f : model.getDeclaredFields()) {
            if (!LocalizedValue.class.isAssignableFrom(f.getType()) && !object.has(f.getName())) continue;
            Class<?> objectType = f.getType();
            String currentPath = pathSoFar + (pathSoFar.equals("") ? "" : ".") + f.getName();
            if (PagedArray.class.isAssignableFrom(f.getType())) {
                JSONObject jsonPagingObject = object.optJSONObject(f.getName() + ".pagination");
                JSONArray jsonArray = object.optJSONArray(f.getName());
                if (jsonPagingObject == null || jsonArray == null) continue;
                try {
                    long totalRecords = jsonPagingObject.getLong("totalRecords");
                    long limit = jsonPagingObject.getLong("limit");
                    long offset = jsonPagingObject.getLong("offset");
                    ParameterizedType genericTypeClazz = (ParameterizedType)f.getGenericType();
                    if (genericTypeClazz.getActualTypeArguments().length != 1) continue;
                    Class arrayObjectType = (Class)genericTypeClazz.getActualTypeArguments()[0];
                    ArrayList arrayObj = ContentDataDeserializer.deserializeArray(instanceId, arrayObjectType, jsonArray, currentPath);
                    Constructor<?> paginationConstructor = f.getType().getDeclaredConstructor(String.class, String.class, Class.class, Long.TYPE, Long.TYPE, Long.TYPE, ArrayList.class);
                    paginationConstructor.setAccessible(true);
                    PagedArray pagedArray = (PagedArray)paginationConstructor.newInstance(instanceId, currentPath, model, totalRecords, limit, offset, arrayObj);
                    f.set(contentDataObj, pagedArray);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (InvocationTargetException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (InstantiationException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializePageObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializePageObject.MALFORMED_JSON");
                }
            }
            if (object.optJSONArray(f.getName()) != null) {
                Object paginationConstructor = null;
                try {
                    ArrayList objectArray = new ArrayList();
                    ParameterizedType genericTypeClazz = (ParameterizedType)f.getGenericType();
                    if (genericTypeClazz.getActualTypeArguments().length != 1) continue;
                    Class arrayObjectType = (Class)genericTypeClazz.getActualTypeArguments()[0];
                    ArrayList arrayObj = ContentDataDeserializer.deserializeArray(instanceId, arrayObjectType, object.optJSONArray(f.getName()), currentPath);
                    if (List.class.isAssignableFrom(f.getType())) {
                        f.set(contentDataObj, arrayObj);
                        continue;
                    }
                    throw new FlybitsException("ContentDataDeserializer.deserializeArrayObject.NOT_PAGEDARRAY_OR_LIST");
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArrayObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArrayObject.CANNOT_INSTANTIATE_OBJ");
                }
            }
            if (LocalizedValue.class.isAssignableFrom(f.getType())) {
                JSONObject jsonLocalizationObject = object.optJSONObject("localizations");
                try {
                    if (jsonLocalizationObject == null) continue;
                    LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
                    Iterator keys = jsonLocalizationObject.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (jsonLocalizationObject.getJSONObject(key).isNull(f.getName())) continue;
                        values.put(key, jsonLocalizationObject.getJSONObject(key).getString(f.getName()));
                    }
                    LocalizedValue value = new LocalizedValue("en", "en");
                    for (String key : ((HashMap)values).keySet()) {
                        value.addValue(key, (String)((HashMap)values).get(key));
                    }
                    f.set(contentDataObj, value);
                    continue;
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeLocalizationObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeLocalizationObject.CANNOT_INSTANTIATE_OBJ");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeLocalizationObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeLocalizationObject.MALFORMED_JSON");
                }
            }
            if (ContentDataDeserializer.checkIfPrimitiveType(f.getType())) {
                try {
                    Object jsonObject = object.get(f.getName());
                    Class<?> jsonType = jsonObject.getClass();
                    if (objectType.getName().equals("java.lang.Float") && jsonObject instanceof Double) {
                        f.set(contentDataObj, (Double)jsonObject);
                        continue;
                    }
                    if (objectType.getName().equals("java.lang.Double") && jsonObject instanceof Float) {
                        f.set(contentDataObj, ((Float)jsonObject).doubleValue());
                        continue;
                    }
                    if (objectType.getName().equals("java.lang.Integer") && jsonObject instanceof Long) {
                        f.set(contentDataObj, ((Long)jsonObject).intValue());
                        continue;
                    }
                    if (objectType.getName().equals("java.lang.Long") && jsonObject instanceof Integer) {
                        f.set(contentDataObj, ((Integer)jsonObject).longValue());
                        continue;
                    }
                    f.set(contentDataObj, jsonObject);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                    throw new FlybitsException(String.format(Locale.getDefault(), "ContentDataDeserializer.deserializeObject.JSON_POJO_DIFFER: Double check that the template and the POJO match! Field Name: %s", f.getName()));
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_SET_PRIMITIVE");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeObject.MALFORMED_JSON");
                }
            }
            if (object.optJSONObject(f.getName()) == null) continue;
            Constructor<?> objConstructor = null;
            try {
                objConstructor = f.getType().getDeclaredConstructor(new Class[0]);
                objConstructor.setAccessible(true);
                Object objInstantiated = objConstructor.newInstance(new Object[0]);
                ContentDataDeserializer.deserializeObject(instanceId, objInstantiated.getClass(), objInstantiated, object.getJSONObject(f.getName()), currentPath);
                f.set(contentDataObj, objInstantiated);
            }
            catch (NoSuchMethodException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_INSTANTIATE_OBJ");
            }
            catch (InvocationTargetException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_INSTANTIATE_OBJ");
            }
            catch (IllegalAccessException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_INSTANTIATE_OBJ");
            }
            catch (InstantiationException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)e);
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.CANNOT_INSTANTIATE_OBJ");
            }
            catch (JSONException e) {
                Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)((Object)e));
                throw new FlybitsException("ContentDataDeserializer.deserializeObject.MALFORMED_JSON");
            }
        }
    }

    private static ArrayList deserializeArray(String instanceId, Class model, JSONArray array, String currentPath) throws FlybitsException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (ContentDataDeserializer.checkIfPrimitiveType(model)) {
            for (int i = 0; i < array.length(); ++i) {
                String arrayPath = currentPath + "[" + i + "]";
                try {
                    Object jsonObject = array.get(i);
                    Class<?> jsonType = jsonObject.getClass();
                    if (model.getName().equals("java.lang.Float") && jsonObject instanceof Double) {
                        list.add(Float.valueOf(((Double)jsonObject).floatValue()));
                        continue;
                    }
                    if (model.getName().equals("java.lang.Double") && jsonObject instanceof Float) {
                        list.add(((Float)jsonObject).doubleValue());
                        continue;
                    }
                    if (model.getName().equals("java.lang.Integer") && jsonObject instanceof Long) {
                        list.add(((Long)jsonObject).intValue());
                        continue;
                    }
                    if (model.getName().equals("java.lang.Long") && jsonObject instanceof Integer) {
                        list.add(((Integer)jsonObject).longValue());
                        continue;
                    }
                    list.add(jsonObject);
                    continue;
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeObject", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeObject.MALFORMED_JSON");
                }
            }
        } else {
            for (int i = 0; i < array.length(); ++i) {
                String arrayPath = currentPath + "[" + i + "]";
                try {
                    JSONObject jsonObj = array.getJSONObject(i);
                    Constructor objConstructor = null;
                    objConstructor = model.getDeclaredConstructor(new Class[0]);
                    objConstructor.setAccessible(true);
                    Object objInstantiated = objConstructor.newInstance(new Object[0]);
                    ContentDataDeserializer.deserializeObject(instanceId, objInstantiated.getClass(), objInstantiated, jsonObj, arrayPath);
                    list.add(objInstantiated);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.CANNOT_INSTANTIATE_OBJ");
                }
                catch (InvocationTargetException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.CANNOT_INSTANTIATE_OBJ");
                }
                catch (IllegalAccessException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.CANNOT_INSTANTIATE_OBJ");
                }
                catch (InstantiationException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)e);
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.CANNOT_INSTANTIATE_OBJ");
                }
                catch (JSONException e) {
                    Logger.exception((String)"ContentDataDeserializer.deserializeArray", (Exception)((Object)e));
                    throw new FlybitsException("ContentDataDeserializer.deserializeArray.MALFORMED_JSON");
                }
            }
        }
        return list;
    }

    private static boolean checkIfPrimitiveType(Class type) {
        return type.getName().equals("java.lang.String") || type.getName().equals("java.lang.Boolean") || type.getName().equals("boolean") || type.getName().equals("java.lang.Float") || type.getName().equals("float") || type.getName().equals("java.lang.Double") || type.getName().equals("double") || type.getName().equals("java.lang.Integer") || type.getName().equals("int") || type.getName().equals("java.lang.Long") || type.getName().equals("long");
    }

    public static <T extends Parcelable> PagedArray<T> extractPagedArray(Object object, String fieldPath) throws FlybitsException {
        if (!fieldPath.contains(".")) {
            try {
                Field f = object.getClass().getDeclaredField(fieldPath);
                if (f != null && PagedArray.class.isAssignableFrom(f.getType())) {
                    PagedArray array = (PagedArray)f.get(object);
                    return array;
                }
            }
            catch (NoSuchFieldException e) {
                throw new FlybitsException("Reflection Error");
            }
            catch (IllegalAccessException e) {
                throw new FlybitsException("Reflection Error");
            }
        }
        String fieldName = fieldPath.substring(0, fieldPath.indexOf("."));
        try {
            Field f = object.getClass().getDeclaredField(fieldName);
            if (f != null && !f.getType().isPrimitive() && !f.getType().isArray()) {
                Object o = f.get(object);
                return ContentDataDeserializer.extractPagedArray(o, fieldPath.substring(fieldPath.indexOf(".") + 1));
            }
        }
        catch (NoSuchFieldException e) {
            throw new FlybitsException("Reflection Error");
        }
        catch (IllegalAccessException e) {
            throw new FlybitsException("Reflection Error");
        }
        return null;
    }
}

