/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.models;

import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.deserializers.DeserializeGroup;
import com.flybits.android.kernel.models.Experience;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.results.GroupResult;
import com.flybits.android.kernel.utilities.GroupParameters;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Entity(tableName="groups")
public class Group
implements Parcelable {
    public static final String API = "/kernel/experiences/groups";
    @PrimaryKey
    private String id;
    private String creatorId;
    private LocalizedValue nameObject;
    private LocalizedValue descriptionObject;
    private long createdAt;
    private long modifiedAt;
    private String defaultLanguage;
    @Ignore
    private ArrayList<Experience> experiences;
    public static final Parcelable.Creator<Group> CREATOR = new Parcelable.Creator<Group>(){

        public Group createFromParcel(Parcel in) {
            return new Group(in);
        }

        public Group[] newArray(int size) {
            return new Group[size];
        }
    };

    public Group() {
    }

    @Ignore
    public Group(@NonNull String id, @NonNull String creatorId, @NonNull ArrayList<Experience> experiences, long createdAt, long modifiedAt, @NonNull String defaultLang) {
        this.id = id;
        this.creatorId = creatorId;
        this.experiences = experiences;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.defaultLanguage = defaultLang;
        this.nameObject = new LocalizedValue(defaultLang, defaultLang);
        this.descriptionObject = new LocalizedValue(defaultLang, defaultLang);
    }

    @Ignore
    protected Group(Parcel in) {
        this.id = in.readString();
        this.creatorId = in.readString();
        this.experiences = in.createTypedArrayList(Experience.CREATOR);
        this.nameObject = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.descriptionObject = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.createdAt = in.readLong();
        this.modifiedAt = in.readLong();
        this.defaultLanguage = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.creatorId);
        dest.writeTypedList(this.experiences);
        dest.writeParcelable((Parcelable)this.nameObject, flags);
        dest.writeParcelable((Parcelable)this.descriptionObject, flags);
        dest.writeLong(this.createdAt);
        dest.writeLong(this.modifiedAt);
        dest.writeString(this.defaultLanguage);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getDescription() {
        return this.descriptionObject.getValue();
    }

    public String getDescription(String languageCode) {
        return this.descriptionObject.getValue(languageCode);
    }

    public LocalizedValue getDescriptionObject() {
        return this.descriptionObject;
    }

    public ArrayList<Experience> getExperiences() {
        return this.experiences;
    }

    public String getId() {
        return this.id;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public String getName() {
        return this.nameObject.getValue();
    }

    public String getName(String languageCode) {
        return this.nameObject.getValue(languageCode);
    }

    public LocalizedValue getNameObject() {
        return this.nameObject;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setDescription(@NonNull String description) {
        this.descriptionObject.addValue(this.defaultLanguage, description);
    }

    public void setDescription(@NonNull String languageCode, @NonNull String description) {
        this.descriptionObject.addValue(languageCode, description);
    }

    public void setDescriptionObject(LocalizedValue value) {
        this.descriptionObject = value;
    }

    public void setExperiences(ArrayList<Experience> experiences) {
        this.experiences = experiences;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModifiedAt(long modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public void setName(@NonNull String name) {
        this.nameObject.addValue(this.defaultLanguage, name);
    }

    public void setName(@NonNull String languageCode, @NonNull String name) {
        this.nameObject.addValue(languageCode, name);
    }

    public void setNameObject(LocalizedValue value) {
        this.nameObject = value;
    }

    public static GroupResult get(final Context mContext, final GroupParameters params, final PagedResultCallback<Group> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final GroupResult result = new GroupResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializeGroup singleDeserializaer = new DeserializeGroup(mContext);
                    DeserializePagedResponse deserializer = new DeserializePagedResponse((IDeserializer)singleDeserializaer);
                    final Result getGroups = FlyAway.get((Context)mContext, (String)Group.API, (QueryParameters)params, (IDeserializer)deserializer, (String)"Group.get");
                    if (getGroups.getStatus() == RequestStatus.COMPLETED) {
                        if (params == null || params.getQueryParams().get("offset") == null || params.getQueryParams().get("offset").size() == 0 || params.getQueryParams().get("offset").get(0).equals("0")) {
                            KernelDatabase.getDatabase(mContext).contentDao().clear();
                        }
                        KernelDatabase.getDatabase(mContext).groupDao().insert(((PagedResponse)getGroups.getResult()).getItems());
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setResult(getGroups, params);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onException(e);
                        }
                    });
                }
            }
        });
        return result;
    }

    public static GroupResult get(Context mContext, GroupParameters params) {
        return Group.get(mContext, params, null);
    }

    public ObjectResult<Group> update(final Context mContext, ObjectResultCallback<Group> callback) throws FlybitsException {
        if (this.id == null) {
            throw new FlybitsException("You must have an id set to able to delete an Group");
        }
        if (this.getNameObject().getListOfSupportedLanguages().size() == 0) {
            throw new FlybitsException("You must have at least one name defined");
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult request = new ObjectResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializeGroup deserializer = new DeserializeGroup(mContext);
                    String json = deserializer.toJson(Group.this);
                    final Result updated = FlyAway.put((Context)mContext, (String)Group.API, (String)json, (IDeserializer)deserializer, (String)"Group.update", Group.class);
                    if (updated.getStatus() == RequestStatus.COMPLETED) {
                        KernelDatabase.getDatabase(mContext).groupDao().update((Group)updated.getResult());
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(updated);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public ObjectResult<Group> create(final Context mContext, ObjectResultCallback<Group> callback) throws FlybitsException {
        if (this.getNameObject().getListOfSupportedLanguages().size() == 0) {
            throw new FlybitsException("You must have at least one name defined");
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult request = new ObjectResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializeGroup deserializer = new DeserializeGroup(mContext);
                    String json = deserializer.toJson(Group.this);
                    final Result created = FlyAway.post((Context)mContext, (String)Group.API, (String)json, (IDeserializer)deserializer, (String)"Group.create", Group.class);
                    if (created.getStatus() == RequestStatus.COMPLETED) {
                        KernelDatabase.getDatabase(mContext).groupDao().insert((Group)created.getResult());
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(created);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public BasicResult delete(final Context mContext, BasicResultCallback callback) throws FlybitsException {
        if (this.id == null) {
            throw new FlybitsException("You must have an id set to able to delete an Group");
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result deleted = FlyAway.delete((Context)mContext, (String)Group.API, (String)"Group.delete", (String)Group.this.id);
                    if (deleted.getStatus() == RequestStatus.COMPLETED) {
                        KernelDatabase.getDatabase(mContext).groupDao().delete(Group.this);
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(deleted);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public int describeContents() {
        return 0;
    }
}

