/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db.dao;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import com.flybits.android.kernel.db.converters.LocalizedValueConverters;
import com.flybits.android.kernel.db.dao.ContentDao;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.LocalizedValue;
import java.util.ArrayList;
import java.util.List;

public class ContentDao_Impl
implements ContentDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfContent;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public ContentDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContent = new EntityInsertionAdapter<Content>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `content`(`id`,`templateId`,`nameObject`,`descriptionObject`,`createdAt`,`modifiedAt`,`icon`,`dataAsJson`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Content value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getTemplateId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTemplateId());
                }
                String _tmp = LocalizedValueConverters.localizedvalueToString(value.getNameObject());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = LocalizedValueConverters.localizedvalueToString(value.getDescriptionObject());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                stmt.bindLong(5, value.getCreatedAt());
                stmt.bindLong(6, value.getModifiedAt());
                if (value.getIcon() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getIcon());
                }
                if (value.getDataAsJson() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getDataAsJson());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM content";
                return "DELETE FROM content";
            }
        };
    }

    @Override
    public void insertOrReplaceNewContent(List<Content> content) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContent.insert(content);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    @Override
    public LiveData<List<Content>> getLive() {
        String _sql = "SELECT * FROM content";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content", (int)0);
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated() {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item.setDataAsJson(_tmpDataAsJson);
                        _result.add(_item);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getAll() {
        String _sql = "SELECT * FROM content";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item.setDataAsJson(_tmpDataAsJson);
                _result.add(_item);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getById(String id) {
        String _sql = "SELECT * FROM content WHERE id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            Content _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            if (_cursor.moveToFirst()) {
                _result = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _result.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _result.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _result.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _result.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _result.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _result.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _result.setDataAsJson(_tmpDataAsJson);
            } else {
                _result = null;
            }
            Content content = _result;
            return content;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Content>> getByIdLive(String id) {
        String _sql = "SELECT * FROM content WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated() {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item.setDataAsJson(_tmpDataAsJson);
                        _result.add(_item);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Content> getAllByTemplateId(String templateId) {
        String _sql = "SELECT * FROM content WHERE templateId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE templateId = ?", (int)1);
        int _argIndex = 1;
        if (templateId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, templateId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
            int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
            int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
            int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
            int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
            int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
            ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Content _item = new Content();
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                _item.setTemplateId(_tmpTemplateId);
                String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                _item.setNameObject(_tmpNameObject);
                String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                _item.setDescriptionObject(_tmpDescriptionObject);
                long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                _item.setCreatedAt(_tmpCreatedAt);
                long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                _item.setModifiedAt(_tmpModifiedAt);
                String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                _item.setIcon(_tmpIcon);
                String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                _item.setDataAsJson(_tmpDataAsJson);
                _result.add(_item);
            }
            ArrayList<Content> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Content>> getAllByTemplateIdLive(String templateId) {
        String _sql = "SELECT * FROM content WHERE templateId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM content WHERE templateId = ?", (int)1);
        int _argIndex = 1;
        if (templateId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, templateId);
        }
        return new ComputableLiveData<List<Content>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Content> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("content", new String[0]){

                        public void onInvalidated() {
                            this.invalidate();
                        }
                    };
                    ContentDao_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = ContentDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("id");
                    int _cursorIndexOfTemplateId = _cursor.getColumnIndexOrThrow("templateId");
                    int _cursorIndexOfNameObject = _cursor.getColumnIndexOrThrow("nameObject");
                    int _cursorIndexOfDescriptionObject = _cursor.getColumnIndexOrThrow("descriptionObject");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfModifiedAt = _cursor.getColumnIndexOrThrow("modifiedAt");
                    int _cursorIndexOfIcon = _cursor.getColumnIndexOrThrow("icon");
                    int _cursorIndexOfDataAsJson = _cursor.getColumnIndexOrThrow("dataAsJson");
                    ArrayList<Content> _result = new ArrayList<Content>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Content _item = new Content();
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _item.setId(_tmpId);
                        String _tmpTemplateId = _cursor.getString(_cursorIndexOfTemplateId);
                        _item.setTemplateId(_tmpTemplateId);
                        String _tmp = _cursor.getString(_cursorIndexOfNameObject);
                        LocalizedValue _tmpNameObject = LocalizedValueConverters.fromString(_tmp);
                        _item.setNameObject(_tmpNameObject);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfDescriptionObject);
                        LocalizedValue _tmpDescriptionObject = LocalizedValueConverters.fromString(_tmp_1);
                        _item.setDescriptionObject(_tmpDescriptionObject);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        _item.setCreatedAt(_tmpCreatedAt);
                        long _tmpModifiedAt = _cursor.getLong(_cursorIndexOfModifiedAt);
                        _item.setModifiedAt(_tmpModifiedAt);
                        String _tmpIcon = _cursor.getString(_cursorIndexOfIcon);
                        _item.setIcon(_tmpIcon);
                        String _tmpDataAsJson = _cursor.getString(_cursorIndexOfDataAsJson);
                        _item.setDataAsJson(_tmpDataAsJson);
                        _result.add(_item);
                    }
                    ArrayList<Content> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }
}

