/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.models;

import android.arch.persistence.room.Entity;
import android.arch.persistence.room.PrimaryKey;
import android.arch.persistence.room.TypeConverters;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.db.converters.LocalizedValueConverters;
import com.flybits.android.kernel.deserializers.DeserializeExperience;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.results.ExperienceResult;
import com.flybits.android.kernel.utilities.ExperienceParameters;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Entity(tableName="experiences")
public class Experience
implements Parcelable {
    public static final String API = "/kernel/experiences";
    @PrimaryKey
    private String id;
    private String creatorID;
    private boolean isActive;
    private long createdAt;
    private long modifiedAt;
    private LocalizedValue name;
    @TypeConverters(value={LocalizedValueConverters.class})
    private ArrayList<String> labels;
    @TypeConverters(value={LocalizedValueConverters.class})
    private LocalizedValue description;
    public static final Parcelable.Creator<Experience> CREATOR = new Parcelable.Creator<Experience>(){

        public Experience createFromParcel(Parcel in) {
            return new Experience(in);
        }

        public Experience[] newArray(int size) {
            return new Experience[size];
        }
    };

    private Experience(String creatorID, boolean isActive) {
        this.creatorID = creatorID;
        this.isActive = isActive;
    }

    public Experience(@NonNull Context context, @NonNull String defaultLanguage, boolean isActive) {
        this(SharedElements.getUserID((Context)context), isActive);
        ArrayList deviceDefaultLanguages = SharedElements.getEnabledLanguagesAsArray((Context)context);
        String deviceDefaultLanguage = deviceDefaultLanguages.size() == 0 ? defaultLanguage : (String)deviceDefaultLanguages.get(0);
        this.name = new LocalizedValue(defaultLanguage, deviceDefaultLanguage);
        this.description = new LocalizedValue(defaultLanguage, deviceDefaultLanguage);
    }

    public Experience(@NonNull String id, @NonNull String creatorID, @NonNull String defaultLanguage, boolean isActive, long createdAt, long modifiedAt, @NonNull String deviceDefaultLanguage, ArrayList<String> labels) {
        this(creatorID, isActive);
        this.id = id;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = new LocalizedValue(defaultLanguage, deviceDefaultLanguage);
        this.description = new LocalizedValue(defaultLanguage, deviceDefaultLanguage);
        this.labels = labels;
    }

    protected Experience(Parcel in) {
        this(in.readString(), in.readInt() == 1);
        this.id = in.readString();
        this.createdAt = in.readLong();
        this.modifiedAt = in.readLong();
        this.labels = in.createStringArrayList();
        this.name = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.description = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.creatorID);
        dest.writeInt(this.isActive ? 1 : 0);
        dest.writeString(this.id);
        dest.writeLong(this.createdAt);
        dest.writeLong(this.modifiedAt);
        dest.writeStringList(this.labels);
        dest.writeParcelable((Parcelable)this.name, flags);
        dest.writeParcelable((Parcelable)this.description, flags);
    }

    public ObjectResult<Experience> create(final Context mContext, ObjectResultCallback<Experience> callback) throws FlybitsException {
        if (this.getNameObject().getListOfSupportedLanguages().size() == 0) {
            throw new FlybitsException("You must have at least one name defined");
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult request = new ObjectResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializeExperience deserializer = new DeserializeExperience(mContext);
                    String json = deserializer.toJson(Experience.this);
                    final Result created = FlyAway.post((Context)mContext, (String)Experience.API, (String)json, (IDeserializer)deserializer, (String)"Experience.create", Experience.class);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(created);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public BasicResult delete(final Context mContext, BasicResultCallback callback) throws FlybitsException {
        if (this.id == null) {
            throw new FlybitsException("You must have an id set to able to delete an Experience");
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result deleted = FlyAway.delete((Context)mContext, (String)Experience.API, (String)"Experience.delete", (String)Experience.this.id);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(deleted);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public static ExperienceResult get(final Context mContext, final ExperienceParameters params, final PagedResultCallback<Experience> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ExperienceResult result = new ExperienceResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializeExperience singleDeserializaer = new DeserializeExperience(mContext);
                    DeserializePagedResponse deserializer = new DeserializePagedResponse((IDeserializer)singleDeserializaer);
                    final Result getExperiences = FlyAway.get((Context)mContext, (String)Experience.API, (QueryParameters)params, (IDeserializer)deserializer, (String)"FlyExperience.get");
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setResult(getExperiences, params);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onException(e);
                        }
                    });
                }
            }
        });
        return result;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatorID() {
        return this.creatorID;
    }

    public String getDescription() {
        return this.description.getValue();
    }

    public String getDescription(String languageCode) {
        return this.description.getValue(languageCode);
    }

    public LocalizedValue getDescriptionObject() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public ArrayList<String> getLabels() {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        return this.labels;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public String getName() {
        return this.name.getValue();
    }

    public String getName(String languageCode) {
        return this.name.getValue(languageCode);
    }

    public LocalizedValue getNameObject() {
        return this.name;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setDescription(@NonNull String languageCode, @NonNull String description) {
        this.description.addValue(languageCode, description);
    }

    public void setName(@NonNull String languageCode, @NonNull String name) {
        this.name.addValue(languageCode, name);
    }

    public ObjectResult<Experience> update(final Context mContext, ObjectResultCallback<Experience> callback) throws FlybitsException {
        if (this.id == null) {
            throw new FlybitsException("You must have an id set to able to delete an Experience");
        }
        if (this.getNameObject().getListOfSupportedLanguages().size() == 0) {
            throw new FlybitsException("You must have at least one name defined");
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult request = new ObjectResult(mContext, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializeExperience deserializer = new DeserializeExperience(mContext);
                    String json = deserializer.toJson(Experience.this);
                    final Result updated = FlyAway.put((Context)mContext, (String)Experience.API, (String)json, (IDeserializer)deserializer, (String)"Experience.update", Experience.class);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(updated);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public int describeContents() {
        return 0;
    }
}

